/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.update;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.plugin.SquirtgunPlugin;
import net.lucypoulton.squirtgun.update.UpdateChecker;

public class PolymartUpdateChecker
extends UpdateChecker {
    public PolymartUpdateChecker(SquirtgunPlugin<?> plugin, int id, Component updateMessage, String listenerPermission) {
        super(plugin, "https://api.polymart.org/v1/getResourceInfo?resource_id=" + id, updateMessage, listenerPermission);
    }

    @Override
    protected boolean checkDataForUpdate(String input) {
        JsonObject object = new JsonParser().parse(input).getAsJsonObject();
        JsonObject response = object.getAsJsonObject("response");
        if (!response.get("success").getAsBoolean()) {
            this.getPlugin().getPlatform().getLogger().severe("Failed to access Polymart to check for updates! Please report this to the plugin developer.");
            return false;
        }
        String version = response.getAsJsonObject("resource").getAsJsonObject("updates").getAsJsonObject("latest").get("version").getAsString();
        return !this.getPlugin().getPluginVersion().equals(version);
    }
}

