/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.platform.scheduler;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.lucypoulton.squirtgun.platform.Platform;

public class Task {
    private final Consumer<Platform> action;
    private final int delay;
    private final int interval;
    private final boolean isAsync;
    private final long id;

    private Task(Consumer<Platform> action, int delay, int interval, boolean isAsync, long id) {
        this.action = action;
        this.delay = delay;
        this.interval = interval;
        this.isAsync = isAsync;
        this.id = id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Consumer<Platform> action) {
        return new Builder().action(action);
    }

    public static Builder builder(Runnable action) {
        return new Builder().action(action);
    }

    public boolean isRepeating() {
        return this.interval != -1;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getInterval() {
        return this.interval;
    }

    public void execute(Platform platform) {
        this.action.accept(platform);
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "Task{id=" + this.id + ", action=" + this.action + ", delay=" + this.delay + ", interval=" + this.interval + ", isAsync=" + this.isAsync + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Task that = (Task)other;
        return this.delay == that.delay && this.interval == that.interval && this.isAsync == that.isAsync && this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.delay, this.interval, this.isAsync, this.id);
    }

    public static class Builder {
        private static final AtomicLong ID_SUPPLIER = new AtomicLong(0L);
        private int interval = -1;
        private int delay = 0;
        private boolean isAsync = false;
        private Consumer<Platform> action;

        public Builder interval(int interval) {
            Preconditions.checkArgument((interval > 0 ? 1 : 0) != 0, (Object)"Interval was not greater than 0");
            this.interval = interval;
            return this;
        }

        public Builder delay(int delay) {
            Preconditions.checkArgument((delay > 0 ? 1 : 0) != 0, (Object)"Delay was not greater than 0");
            this.delay = delay;
            return this;
        }

        public Builder async() {
            this.isAsync = true;
            return this;
        }

        public Builder action(Consumer<Platform> action) {
            this.action = action;
            return this;
        }

        public Builder action(Runnable action) {
            this.action = p -> action.run();
            return this;
        }

        public Task build() {
            Preconditions.checkNotNull(this.action, (Object)"Action has not been set");
            return new Task(this.action, this.delay, this.interval, this.isAsync, ID_SUPPLIER.getAndIncrement());
        }
    }
}

