/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.platform.event;

import net.lucypoulton.squirtgun.platform.event.cancellable.CancellableEvent;
import org.jetbrains.annotations.Nullable;

public interface Event {

    @FunctionalInterface
    public static interface Result {
        public static final Result SUCCESS = () -> true;
        public static final Result FAILURE = () -> false;

        public static Result ofCancellable(CancellableEvent event) {
            return () -> !event.isCancelled();
        }

        public static Result withReason(final boolean success, final String reason) {
            return new Result(){

                @Override
                public boolean successful() {
                    return success;
                }

                @Override
                @Nullable
                public String reason() {
                    return reason;
                }
            };
        }

        public boolean successful();

        default public boolean failed() {
            return !this.successful();
        }

        @Nullable
        default public String reason() {
            return null;
        }
    }
}

