/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;
import net.lucypoulton.squirtgun.format.FormatProvider;
import net.lucypoulton.squirtgun.format.TextWidthFinder;
import net.lucypoulton.squirtgun.format.blocked.BlockedGradient;
import net.lucypoulton.squirtgun.format.blocked.BlockedGradientPattern;
import net.lucypoulton.squirtgun.format.pattern.FormatPattern;
import net.lucypoulton.squirtgun.format.pattern.HexPattern;
import net.lucypoulton.squirtgun.format.pattern.HsvGradientPattern;
import net.lucypoulton.squirtgun.format.pattern.LegacyAmpersandPattern;
import net.lucypoulton.squirtgun.format.pattern.RgbGradientPattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFormatter {
    private static final List<FormatPattern> patterns = new ArrayList<FormatPattern>();
    private static final Pattern formatterPattern = Pattern.compile("\\{[^{}]+>}.*\\{[^{}]+<}|(\\{[^{}]+})?[^{}]+");
    private static final String TITLE_SEPARATOR = " ";
    private static final int CHAT_WIDTH = 320;

    @Deprecated
    @Contract(pure=true)
    public static String repeat(@NotNull String charToRepeat, int count) {
        return charToRepeat.repeat(Math.max(0, count));
    }

    @Contract(pure=true)
    public static Component invert(Component component) {
        ArrayList<Component> comps = new ArrayList<Component>();
        for (int i = component.children().size() - 1; i >= 0; --i) {
            comps.add((Component)component.children().get(i));
        }
        comps.add(component.children(new ArrayList()));
        return ((Component)comps.get(0)).children(comps.subList(1, comps.size()));
    }

    @Deprecated
    @Contract(pure=true)
    public static Component formatTitle(@NotNull String in, @NotNull FormatProvider format) {
        return TextFormatter.centreText(in, format, TITLE_SEPARATOR, new TextDecoration[]{TextDecoration.STRIKETHROUGH});
    }

    @Contract(pure=true)
    public static Component centreText(@NotNull String in, @NotNull FormatProvider format, @NotNull String character) {
        return TextFormatter.centreText(in, format, character, new TextDecoration[0]);
    }

    @Contract(pure=true)
    public static Component centreText(@NotNull String in, @NotNull FormatProvider format, @NotNull String character, @NotNull TextDecoration[] formatters) {
        int spaceLength = (320 - TextWidthFinder.findWidth(in) - 6) / 2;
        Component line = format.formatAccent(character.repeat(spaceLength / TextWidthFinder.findWidth(character)), formatters);
        Component centre = format.formatMain(TITLE_SEPARATOR + in + TITLE_SEPARATOR);
        for (TextDecoration deco : formatters) {
            centre = centre.decoration(deco, false);
        }
        return line.append(centre).append(TextFormatter.invert(line));
    }

    @Contract(pure=true)
    @Nullable
    public static TextColor colourFromText(@NotNull String in) {
        if (in.length() == 1) {
            return Objects.requireNonNull(LegacyComponentSerializer.parseChar((char)in.charAt(0))).color();
        }
        if (in.length() == 7 && in.startsWith("#")) {
            try {
                return TextColor.fromCSSHexString((String)in);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @Contract(pure=true)
    public static Component format(@NotNull String input) {
        return TextFormatter.format(input, null, false);
    }

    @Contract(pure=true)
    public static Component format(@NotNull String input, @Nullable String overrides, boolean usePredefinedFormatters) {
        if (usePredefinedFormatters && input.contains("\u00a7")) {
            return LegacyComponentSerializer.legacySection().deserialize(input.replaceAll("(?<!\\\\)(\\{[^}]*}|&[0-9A-Fa-fK-Ok-o])", ""));
        }
        input = input.replaceAll("\u00a7.", "");
        TextComponent output = null;
        Matcher matcher = formatterPattern.matcher(input);
        while (matcher.find()) {
            boolean hasBeenParsed = false;
            for (FormatPattern pattern : patterns) {
                Component component = pattern.process(matcher.group(), overrides);
                if (component == null) continue;
                hasBeenParsed = true;
                if (output == null) {
                    output = component;
                    break;
                }
                output = output.append(component);
                break;
            }
            if (hasBeenParsed) continue;
            TextComponent component = Component.text((String)matcher.group());
            if (output == null) {
                output = component;
                continue;
            }
            output = output.append((Component)component);
        }
        return output;
    }

    @Contract(pure=true)
    public static int[] fade(int count, int val1, int val2) {
        float step = (float)(val2 - val1) / (float)(count - 1);
        int[] output = new int[count];
        for (int x = 0; x < count; ++x) {
            float result;
            for (result = (float)val1 + step * (float)x; result < 0.0f; result += 360.0f) {
            }
            while (result > 360.0f) {
                result -= 360.0f;
            }
            output[x] = Math.round(result);
        }
        return output;
    }

    @Contract(pure=true)
    public static Component applyLegacyDecorations(@NotNull Component in, @Nullable String decorations) {
        if (decorations == null) {
            return in;
        }
        Component out = in;
        for (char c : decorations.toCharArray()) {
            LegacyFormat format = LegacyComponentSerializer.parseChar((char)c);
            if (format == null) {
                throw new IllegalArgumentException("Invalid char " + c);
            }
            TextDecoration deco = format.decoration();
            if (deco == null) {
                throw new IllegalArgumentException("Char " + c + " is not a decorator");
            }
            out = out.decorate(deco);
        }
        return out;
    }

    static {
        patterns.add(new RgbGradientPattern());
        patterns.add(new HsvGradientPattern());
        patterns.add(new HexPattern());
        patterns.add(new LegacyAmpersandPattern());
        patterns.add(new BlockedGradientPattern("flag", new BlockedGradient(new String[]{"transgender", "trans"}, new TextColor[]{TextColor.color((int)5623292), TextColor.color((int)16230584), NamedTextColor.WHITE, TextColor.color((int)16230584), TextColor.color((int)5623292)}), new BlockedGradient(new String[]{"bisexual", "bi"}, TextColor.color((int)14025328), TextColor.color((int)14025328), TextColor.color((int)10178454), TextColor.color((int)14504), TextColor.color((int)14504)), new BlockedGradient("lesbian", new TextColor[]{TextColor.color((int)14035200), TextColor.color((int)16751445), NamedTextColor.WHITE, TextColor.color((int)13918630), TextColor.color((int)10813538)}), new BlockedGradient(new String[]{"nonbinary", "non-binary", "enby"}, new TextColor[]{TextColor.color((int)16774192), NamedTextColor.WHITE, TextColor.color((int)10246609), NamedTextColor.BLACK}), new BlockedGradient(new String[]{"pansexual", "pan"}, TextColor.color((int)16718733), TextColor.color((int)16767488), TextColor.color((int)1815551)), new BlockedGradient(new String[]{"asexual", "ace"}, new TextColor[]{NamedTextColor.BLACK, TextColor.color((int)0xA3A3A3), NamedTextColor.WHITE, TextColor.color((int)8454274)}), new BlockedGradient("genderqueer", new TextColor[]{TextColor.color((int)12025821), NamedTextColor.WHITE, TextColor.color((int)4751902)}), new BlockedGradient(new String[]{"genderfluid", "fluid"}, new TextColor[]{TextColor.color((int)16742051), NamedTextColor.WHITE, TextColor.color((int)12521943), NamedTextColor.BLACK, TextColor.color((int)3161278)})));
    }
}

