/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.node.subcommand;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.command.argument.CommandArgument;
import net.lucypoulton.squirtgun.command.condition.Condition;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.AbstractNode;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.command.node.subcommand.SubcommandHelpNode;
import net.lucypoulton.squirtgun.command.node.subcommand.SubcommandNodeArgument;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubcommandNode
extends AbstractNode<PermissionHolder> {
    private final Set<CommandNode<?>> childNodes;
    private final CommandArgument<CommandNode<?>> argument;
    private CommandNode<?> fallbackNode;

    protected SubcommandNode(@NotNull String name, @NotNull String description, Condition<PermissionHolder, ?> condition, CommandNode<?> ... childNodes) {
        super(name, description, condition);
        Preconditions.checkNotNull(childNodes, (Object)"Child nodes must not be null");
        this.childNodes = new HashSet(Arrays.asList(childNodes));
        this.argument = new SubcommandNodeArgument(this, "subcommand", "The subcommand to execute");
    }

    public static SubcommandNode withHelp(String name, String description, Condition<PermissionHolder, ?> condition, CommandNode<?> ... childNodes) {
        SubcommandNode node = new SubcommandNode(name, description, condition, childNodes);
        node.setFallbackNode(new SubcommandHelpNode(node));
        return node;
    }

    public static SubcommandNode withFallback(String name, String description, Condition<PermissionHolder, ?> condition, @NotNull CommandNode<?> fallback, CommandNode<?> ... childNodes) {
        SubcommandNode node = new SubcommandNode(name, description, condition, childNodes);
        node.setFallbackNode(fallback);
        return node;
    }

    public static SubcommandNode withBasicHelp(String name, String description, Condition<PermissionHolder, ?> condition, CommandNode<?> ... childNodes) {
        return new SubcommandNode(name, description, condition, childNodes);
    }

    public Set<CommandNode<?>> getNodes() {
        return this.childNodes;
    }

    @Nullable
    public CommandNode<?> getFallbackNode() {
        return this.fallbackNode;
    }

    private void setFallbackNode(CommandNode<?> fallback) {
        this.fallbackNode = fallback;
        this.childNodes.add(fallback);
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return ImmutableList.of(this.argument);
    }

    @Override
    @Nullable
    public CommandNode<? extends PermissionHolder> next(CommandContext context) {
        CommandNode<?> name = context.getArgumentValue(this.argument);
        return name == null ? this.fallbackNode : name;
    }

    @Override
    @Nullable
    public Component execute(CommandContext context) {
        return null;
    }
}

