/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.update;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.platform.event.EventHandler;
import net.lucypoulton.squirtgun.platform.event.player.PlayerJoinEvent;
import net.lucypoulton.squirtgun.platform.scheduler.Task;
import net.lucypoulton.squirtgun.plugin.SquirtgunPlugin;

public abstract class UpdateChecker {
    private final SquirtgunPlugin<?> plugin;
    private final Component updateMessage;
    private final String listenerPermission;
    private final String url;
    private final Task listenerTask;
    private boolean updateAvailable;

    protected UpdateChecker(SquirtgunPlugin<?> plugin, String url, Component updateMessage, String listenerPermission) {
        this.plugin = plugin;
        this.url = url;
        this.updateMessage = updateMessage;
        this.listenerPermission = listenerPermission;
        EventHandler<PlayerJoinEvent> joinEventHandler = EventHandler.builder(PlayerJoinEvent.class).handle(e -> {
            if (this.checkDataForUpdate() && e.player().hasPermission(this.getListenerPermission())) {
                e.player().sendMessage(this.getUpdateMessage());
            }
        }).build();
        plugin.getPlatform().getEventManager().register(joinEventHandler);
        if (plugin.getPluginVersion().contains("-")) {
            plugin.getPlatform().getLogger().warning("Development version detected, skipping update check.");
            this.listenerTask = null;
            return;
        }
        this.listenerTask = Task.builder().async().interval(216000).action(x -> this.checkForUpdate()).build();
        plugin.getPlatform().getTaskScheduler().start(this.listenerTask);
    }

    protected abstract boolean checkDataForUpdate(String var1);

    protected SquirtgunPlugin<?> getPlugin() {
        return this.plugin;
    }

    public boolean checkForUpdate() {
        try {
            this.plugin.log("Checking for updates...");
            HttpURLConnection con = (HttpURLConnection)new URL(this.url).openConnection();
            if (con.getResponseCode() != 200) {
                throw new Exception();
            }
            String text = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            if (this.checkDataForUpdate(text)) {
                this.updateAvailable = true;
                this.plugin.getPlatform().log(this.getUpdateMessage());
                this.plugin.getPlatform().getTaskScheduler().cancel(this.listenerTask);
                return true;
            }
            this.plugin.getPlatform().getLogger().info("No update available.");
        }
        catch (Exception ignored) {
            this.plugin.getPlatform().getLogger().warning("Unable to check for updates!");
        }
        return false;
    }

    public Component getUpdateMessage() {
        return this.updateMessage;
    }

    public boolean checkDataForUpdate() {
        return this.updateAvailable;
    }

    public String getListenerPermission() {
        return this.listenerPermission;
    }
}

