/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.format.blocked;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lucypoulton.squirtgun.format.blocked.BlockedGradient;
import net.lucypoulton.squirtgun.format.pattern.FormatPattern;
import org.jetbrains.annotations.NotNull;

public class BlockedGradientPattern
implements FormatPattern {
    private final Pattern pattern;
    private final Map<String, TextColor[]> colours = new HashMap<String, TextColor[]>();

    public BlockedGradientPattern(String name, BlockedGradient ... gradients) {
        this.pattern = Pattern.compile("\\{" + name + ":([A-Za-z]+):?([klmno]+)?>}(.*)\\{" + name + "<}");
        for (BlockedGradient gradient : gradients) {
            for (String gradName : gradient.getNames()) {
                this.colours.put(gradName, gradient.getCols());
            }
        }
    }

    private String safeSubstr(String in, int i, int l) {
        return l >= in.length() ? in.substring(i) : in.substring(i, l);
    }

    @Override
    public Component process(@NotNull String in, String overrideFormatter) {
        String formats;
        Matcher matcher = this.pattern.matcher(in);
        if (!matcher.find()) {
            return null;
        }
        String label = matcher.group(1);
        TextComponent component = Component.empty();
        String string = formats = overrideFormatter == null ? matcher.group(2) : overrideFormatter;
        if (formats != null) {
            for (char c : formats.toCharArray()) {
                component = component.decorate(LegacyComponentSerializer.parseChar((char)c).decoration());
            }
        }
        String content = matcher.group(3);
        TextColor[] cols = this.colours.get(label);
        if (cols == null) {
            return Component.text((String)content);
        }
        float step = (float)content.length() / (float)cols.length;
        ArrayList<Integer> points = new ArrayList<Integer>();
        for (float i = 0.0f; i < (float)content.length(); i += step) {
            points.add(Math.round(i));
        }
        for (int i = 0; i < points.size(); ++i) {
            String text = i + 1 == points.size() ? content.substring((Integer)points.get(i)) : this.safeSubstr(content, (Integer)points.get(i), (Integer)points.get(i + 1));
            component = component.append((Component)Component.text((String)text, (TextColor)cols[i]));
        }
        return component;
    }
}

