/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.format.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.lucypoulton.squirtgun.format.TextFormatter;
import net.lucypoulton.squirtgun.format.pattern.FormatPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RgbGradientPattern
implements FormatPattern {
    final Pattern pattern = Pattern.compile("\\{(#[A-Fa-f0-9]{6}):?([klmno]+)?>}(.*)\\{(#[A-Fa-f0-9]{6})<}");

    private static int clamp(int in) {
        return in > 255 ? 255 : Math.max(in, 0);
    }

    private static Component fade(String col1, String col2, String formats, String text) {
        TextComponent component = Component.empty();
        TextColor color1 = TextColor.fromCSSHexString((String)col1);
        assert (color1 != null);
        if (text.length() == 1) {
            return component.append(Component.text((String)text).color(color1));
        }
        TextColor color2 = TextColor.fromCSSHexString((String)col2);
        assert (color2 != null);
        int[] reds = TextFormatter.fade(text.length(), color1.red(), color2.red());
        int[] greens = TextFormatter.fade(text.length(), color1.green(), color2.green());
        int[] blues = TextFormatter.fade(text.length(), color1.blue(), color2.blue());
        for (int x = 0; x < text.length(); ++x) {
            TextColor color = TextColor.color((int)RgbGradientPattern.clamp(reds[x]), (int)RgbGradientPattern.clamp(greens[x]), (int)RgbGradientPattern.clamp(blues[x]));
            component = component.append((Component)Component.text((char)text.charAt(x), (TextColor)color));
        }
        return TextFormatter.applyLegacyDecorations((Component)component, formats);
    }

    @Override
    @Nullable
    public Component process(@NotNull String in, String formatter) {
        Matcher matcher = this.pattern.matcher(in);
        if (!matcher.find()) {
            return null;
        }
        String col1 = matcher.group(1);
        String formatters = formatter;
        if (formatters == null) {
            formatters = matcher.group(2);
        }
        String text = matcher.group(3);
        String col2 = matcher.group(4);
        return RgbGradientPattern.fade(col1, col2, formatters, text);
    }
}

