/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.node.subcommand;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lucypoulton.squirtgun.command.argument.AbstractArgument;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.command.node.subcommand.SubcommandNode;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.Nullable;

public class SubcommandNodeArgument
extends AbstractArgument<CommandNode<?>> {
    private final SubcommandNode parent;

    public SubcommandNodeArgument(SubcommandNode parent, String name, String description) {
        super(name, description, false);
        this.parent = parent;
    }

    private Stream<? extends CommandNode<?>> getValidNodes(String name, PermissionHolder holder, CommandContext ctx) {
        return this.parent.getNodes().stream().filter(node -> node.getName().toLowerCase(Locale.ROOT).startsWith(name.toLowerCase(Locale.ROOT))).filter(node -> node.getCondition().test(holder, ctx).isSuccessful());
    }

    @Override
    public CommandNode<?> getValue(Queue<String> args, CommandContext context) {
        String raw = args.poll();
        if (raw == null || raw.equals("")) {
            return null;
        }
        return this.getValidNodes(raw, context.getTarget(), context).min(Comparator.comparingInt(a -> a.getName().length())).orElse(null);
    }

    @Override
    @Nullable
    public List<String> tabComplete(Queue<String> args, CommandContext context) {
        String raw = args.poll();
        if (raw == null) {
            return null;
        }
        return this.getValidNodes(raw, context.getTarget(), context).map(CommandNode::getName).collect(Collectors.toList());
    }

    @Override
    public boolean isOptional() {
        return this.parent.getFallbackNode() != null;
    }
}

