/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.node.subcommand;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.lucypoulton.squirtgun.command.argument.CommandArgument;
import net.lucypoulton.squirtgun.command.argument.ListArgument;
import net.lucypoulton.squirtgun.command.condition.Condition;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.command.node.HelpNode;
import net.lucypoulton.squirtgun.command.node.subcommand.SubcommandNode;
import net.lucypoulton.squirtgun.format.FormatProvider;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubcommandHelpNode
implements CommandNode<PermissionHolder> {
    private final SubcommandNode parentNode;
    private final CommandArgument<String> childArgument;

    public SubcommandHelpNode(SubcommandNode parentNode) {
        this.parentNode = parentNode;
        this.childArgument = new ListArgument("command", "The command to get help for.", true, parentNode.getNodes().stream().map(CommandNode::getName).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return ImmutableList.of(this.childArgument);
    }

    @Override
    @NotNull
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Shows this screen.";
    }

    @Override
    @NotNull
    public Condition<PermissionHolder, ? extends PermissionHolder> getCondition() {
        return Condition.alwaysTrue();
    }

    @Override
    @Nullable
    public CommandNode<?> next(CommandContext context) {
        String child = context.getArgumentValue(this.childArgument);
        if (child == null) {
            return null;
        }
        Optional<CommandNode> nodeWithGivenName = this.parentNode.getNodes().stream().filter(node -> node.getName().equals(child)).findFirst();
        return nodeWithGivenName.map(HelpNode::new).orElse(null);
    }

    @Override
    @Nullable
    public Component execute(CommandContext context) {
        FormatProvider fmt = context.getFormat();
        Component out = ((TextComponent)Component.empty().append(fmt.formatTitle("Commands:"))).append((Component)Component.newline());
        for (CommandNode<?> node : this.parentNode.getNodes()) {
            if (!node.getCondition().test(context.getTarget(), context).isSuccessful()) continue;
            Component innerComp = fmt.formatMain(this.parentNode.getName() + " ").append(fmt.formatAccent(node.getName())).append(fmt.formatMain(" - " + node.getDescription())).append((Component)Component.text((String)"\n"));
            out = out.append(innerComp);
        }
        out = out.append((Component)Component.newline()).append(fmt.formatFooter("*"));
        return out;
    }
}

