/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.node;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.command.argument.CommandArgument;
import net.lucypoulton.squirtgun.command.condition.Condition;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeBuilder<T extends PermissionHolder> {
    private final List<CommandArgument<?>> arguments = new ArrayList();
    private String name;
    private String description;
    private Condition<PermissionHolder, T> condition;
    private Function<CommandContext, @Nullable Component> executes;
    private CommandNode<T> next;

    public NodeBuilder<T> name(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        this.name = name;
        return this;
    }

    public NodeBuilder<T> description(@NotNull String description) {
        this.description = description;
        return this;
    }

    public NodeBuilder<T> condition(@NotNull Condition<PermissionHolder, T> condition) {
        Preconditions.checkNotNull(condition, (Object)"Condition must not be null");
        this.condition = condition;
        return this;
    }

    public NodeBuilder<T> executes(@NotNull Function<CommandContext, @Nullable Component> executes) {
        Preconditions.checkNotNull(executes, (Object)"Executes function must not be null");
        this.executes = executes;
        return this;
    }

    public NodeBuilder<T> next(@Nullable CommandNode<T> next) {
        this.next = next;
        return this;
    }

    public NodeBuilder<T> arguments(CommandArgument<?> ... arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
        return this;
    }

    public CommandNode<T> build() {
        return new BuiltCommandNode<T>(Objects.requireNonNull(this.name), this.description, Objects.requireNonNull(this.condition), Objects.requireNonNull(this.executes), this.next, this.arguments);
    }

    private static class BuiltCommandNode<T extends PermissionHolder>
    implements CommandNode<T> {
        private final String name;
        private final String description;
        private final Condition<PermissionHolder, T> condition;
        private final Function<CommandContext, @Nullable Component> executes;
        @Nullable
        private final CommandNode<T> next;
        private final List<CommandArgument<?>> arguments;

        private BuiltCommandNode(String name, String description, Condition<PermissionHolder, T> condition, Function<CommandContext, @Nullable Component> executes, @Nullable CommandNode<T> next, List<CommandArgument<?>> arguments) {
            this.name = name;
            this.description = description;
            this.condition = condition;
            this.executes = executes;
            this.next = next;
            this.arguments = arguments;
        }

        @Override
        @Nullable
        public Component execute(CommandContext context) {
            return this.executes.apply(context);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Condition<PermissionHolder, ? extends T> getCondition() {
            return this.condition;
        }

        @Override
        @NotNull
        public List<CommandArgument<?>> getArguments() {
            return this.arguments;
        }

        @Override
        @Nullable
        public CommandNode<T> next(CommandContext context) {
            return this.next;
        }
    }
}

