/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.node;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.lucypoulton.squirtgun.command.argument.CommandArgument;
import net.lucypoulton.squirtgun.command.condition.Condition;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.format.FormatProvider;
import net.lucypoulton.squirtgun.format.TextFormatter;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpNode
implements CommandNode<PermissionHolder> {
    private final CommandNode<?> parentNode;

    public HelpNode(CommandNode<?> parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    @Nullable
    public Component execute(CommandContext context) {
        FormatProvider format = context.getFormat();
        Component out = ((TextComponent)Component.empty().append(format.formatTitle("Command Help"))).append((Component)Component.newline());
        String fullCommand = this.parentNode.getName() + " " + this.parentNode.getArguments().stream().map(Object::toString).collect(Collectors.joining(" "));
        out = out.append(TextFormatter.centreText(this.parentNode.getDescription(), format, " ")).append((Component)Component.newline()).append(format.formatAccent("Usage")).append(format.formatMain(": " + fullCommand)).append((Component)Component.newline());
        if (this.parentNode.getArguments().size() != 0) {
            out = out.append((Component)Component.newline()).append(TextFormatter.centreText("Arguments", format, " ")).append((Component)Component.newline());
            for (CommandArgument<?> argument : this.parentNode.getArguments()) {
                out = out.append(format.formatAccent(argument.getName())).append(format.formatMain(" - " + argument.getDescription())).append((Component)Component.newline());
            }
        }
        out = out.append((Component)Component.newline()).append(format.formatFooter("*"));
        return out;
    }

    @Override
    @NotNull
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Shows help on using this command.";
    }

    @Override
    @NotNull
    public Condition<PermissionHolder, ? extends PermissionHolder> getCondition() {
        return Condition.alwaysTrue();
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return Collections.emptyList();
    }
}

