/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lucypoulton.squirtgun.command.argument.CommandArgument;
import net.lucypoulton.squirtgun.command.condition.Condition;
import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.command.node.CommandNode;
import net.lucypoulton.squirtgun.format.FormatProvider;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringContext
implements CommandContext {
    private final FormatProvider provider;
    private final PermissionHolder target;
    private final CommandNode<?> node;
    private final String raw;
    private final LinkedHashMap<CommandArgument<?>, Object> argValues = new LinkedHashMap();
    private CommandNode<?> tail;

    public StringContext(FormatProvider provider, PermissionHolder target, CommandNode<?> node, String value) {
        this.node = node;
        this.raw = value;
        this.provider = provider;
        this.target = target;
    }

    private void populateArguments(CommandNode<?> node, Queue<String> raw, boolean findValues) {
        this.tail = node;
        if (!node.getCondition().test(this.getTarget(), this).isSuccessful()) {
            return;
        }
        for (CommandArgument<?> arg : node.getArguments()) {
            this.argValues.put(arg, findValues ? (Object)arg.getValue(raw, this) : null);
        }
        CommandNode<?> next = node.next(this);
        if (next == null) {
            return;
        }
        this.populateArguments(next, raw, findValues);
    }

    private Queue<String> getArgsAsList(String value) {
        return new LinkedList<String>(Arrays.asList(value.split(" ", -1)));
    }

    @Override
    public PermissionHolder getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public <U> U getArgumentValue(CommandArgument<U> name) {
        return (U)this.argValues.get(name);
    }

    @Override
    @Nullable
    public Object getArgumentValue(String name) {
        Optional<CommandArgument> argument = this.argValues.keySet().stream().filter(arg -> arg.getName().equals(name)).findFirst();
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(String.format("Argument %s does not exist", name));
        }
        return this.getArgumentValue(argument.get());
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    @Override
    @NotNull
    public FormatProvider getFormat() {
        return this.provider;
    }

    @Override
    public List<String> tabComplete() {
        Queue<String> rawQueue = this.getArgsAsList(this.raw);
        this.populateArguments(this.node, this.getArgsAsList(this.raw), true);
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        ArrayList argTree = new ArrayList(this.argValues.keySet());
        int argIdx = 0;
        while (!rawQueue.isEmpty()) {
            if (argIdx >= argTree.size()) {
                return null;
            }
            CommandArgument arg = (CommandArgument)argTree.get(argIdx);
            results.add(arg.tabComplete(rawQueue, this));
            ++argIdx;
        }
        return (List)results.get(results.size() - 1);
    }

    @Override
    public Component execute() {
        this.populateArguments(this.node, this.getArgsAsList(this.raw), true);
        Condition.Result<?> result = this.getTail().getCondition().test(this.getTarget(), this);
        if (!result.isSuccessful()) {
            String error = result.getError();
            return error == null ? null : this.getFormat().getPrefix().append(this.getFormat().formatMain(result.getError()));
        }
        for (CommandArgument<?> argument : this.getTail().getArguments()) {
            if (argument.isOptional() || this.getArgumentValue(argument) != null) continue;
            return this.getFormat().getPrefix().append(this.getFormat().formatMain("Usage: " + this.getTail().getName() + " " + this.getTail().getArguments().stream().map(Object::toString).collect(Collectors.joining(" "))));
        }
        return this.getTail().execute(this);
    }

    @Override
    public CommandNode<?> getTail() {
        return this.tail;
    }
}

