/*
 * Decompiled with CFR 0.152.
 */
package net.lucypoulton.squirtgun.command.condition;

import net.lucypoulton.squirtgun.command.context.CommandContext;
import net.lucypoulton.squirtgun.platform.audience.PermissionHolder;
import net.lucypoulton.squirtgun.platform.audience.SquirtgunPlayer;

@FunctionalInterface
public interface Condition<T extends PermissionHolder, U extends PermissionHolder> {
    public static Condition<PermissionHolder, SquirtgunPlayer> isPlayer() {
        return (target, context) -> target instanceof SquirtgunPlayer ? new Result<SquirtgunPlayer>(true, (SquirtgunPlayer)target, null) : new Result<Object>(false, null, "This command can only be run by a player.");
    }

    public static Condition<PermissionHolder, PermissionHolder> isConsole() {
        return (target, context) -> target instanceof SquirtgunPlayer ? new Result<Object>(false, null, "This command can only be run from the console.") : new Result<PermissionHolder>(true, target, null);
    }

    public static <V extends PermissionHolder> Condition<V, V> alwaysTrue() {
        return (target, context) -> new Result<PermissionHolder>(true, target, null);
    }

    public static <V extends PermissionHolder> Condition<V, V> hasPermission(String permission) {
        return (target, context) -> target.hasPermission(permission) ? new Result<PermissionHolder>(true, target, null) : new Result<Object>(false, null, "No permission!");
    }

    public Result<U> test(T var1, CommandContext var2);

    default public <V extends U> Condition<T, V> and(Condition<? super U, V> other) {
        return (target, context) -> {
            Result<U> first = this.test(target, context);
            if (!first.isSuccessful()) {
                return new Result<Object>(false, null, first.getError());
            }
            return other.test((U)((PermissionHolder)first.getResult()), context);
        };
    }

    default public Condition<T, U> or(Condition<? super T, ? extends U> other) {
        return (target, context) -> {
            Result<U> first = this.test(target, context);
            if (first.isSuccessful()) {
                return first;
            }
            Result<U> otherResult = other.test(target, context);
            return new Result<PermissionHolder>(otherResult.successful, (PermissionHolder)otherResult.result, otherResult.error);
        };
    }

    public static class Result<U> {
        private final boolean successful;
        private final U result;
        private final String error;

        public Result(boolean successful, U result, String error) {
            this.successful = successful;
            this.result = result;
            this.error = error;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public final boolean isFailure() {
            return !this.isSuccessful();
        }

        public U getResult() {
            return this.result;
        }

        public String getError() {
            return this.error;
        }
    }
}

