/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.rest.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

abstract class AbstractModel {
    private static final Gson GSON = new Gson();
    private transient String jsonString;
    private transient JsonElement jsonTree;

    AbstractModel() {
    }

    private String asJsonString() {
        String json = this.jsonString;
        if (json == null) {
            this.jsonString = json = GSON.toJson((Object)this);
        }
        return json;
    }

    private JsonElement asJsonTree() {
        JsonElement json = this.jsonTree;
        if (json == null) {
            this.jsonTree = json = GSON.toJsonTree((Object)this);
        }
        return json;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.asJsonString() + ")";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AbstractModel && this.asJsonTree().equals(((AbstractModel)obj).asJsonTree());
    }

    public int hashCode() {
        return this.asJsonTree().hashCode();
    }
}

