/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.rest;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.luckperms.rest.EventCallAdapterFactory;
import net.luckperms.rest.LuckPermsRestClient;
import net.luckperms.rest.service.ActionService;
import net.luckperms.rest.service.EventService;
import net.luckperms.rest.service.GroupService;
import net.luckperms.rest.service.MessagingService;
import net.luckperms.rest.service.MiscService;
import net.luckperms.rest.service.TrackService;
import net.luckperms.rest.service.UserService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class LuckPermsRestClientImpl
implements LuckPermsRestClient {
    private final OkHttpClient httpClient;
    private final EventCallAdapterFactory eventCallAdapterFactory;
    private final UserService userService;
    private final GroupService groupService;
    private final TrackService trackService;
    private final ActionService actionService;
    private final MessagingService messagingService;
    private final EventService eventService;
    private final MiscService miscService;

    LuckPermsRestClientImpl(String baseUrl, String apiKey, Consumer<OkHttpClient.Builder> clientConfigurer) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (apiKey != null && !apiKey.isEmpty()) {
            clientBuilder.addInterceptor((Interceptor)new AuthInterceptor(apiKey));
        }
        clientBuilder.readTimeout(60L, TimeUnit.SECONDS);
        if (clientConfigurer != null) {
            clientConfigurer.accept(clientBuilder);
        }
        this.httpClient = clientBuilder.build();
        this.eventCallAdapterFactory = new EventCallAdapterFactory(this.httpClient);
        Retrofit retrofit = new Retrofit.Builder().client(this.httpClient).baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)this.eventCallAdapterFactory).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).validateEagerly(true).build();
        this.userService = (UserService)retrofit.create(UserService.class);
        this.groupService = (GroupService)retrofit.create(GroupService.class);
        this.trackService = (TrackService)retrofit.create(TrackService.class);
        this.actionService = (ActionService)retrofit.create(ActionService.class);
        this.messagingService = (MessagingService)retrofit.create(MessagingService.class);
        this.eventService = (EventService)retrofit.create(EventService.class);
        this.miscService = (MiscService)retrofit.create(MiscService.class);
    }

    @Override
    public UserService users() {
        return this.userService;
    }

    @Override
    public GroupService groups() {
        return this.groupService;
    }

    @Override
    public TrackService tracks() {
        return this.trackService;
    }

    @Override
    public ActionService actions() {
        return this.actionService;
    }

    @Override
    public MessagingService messaging() {
        return this.messagingService;
    }

    @Override
    public EventService events() {
        return this.eventService;
    }

    @Override
    public MiscService misc() {
        return this.miscService;
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        this.eventCallAdapterFactory.close();
    }

    static final class AuthInterceptor
    implements Interceptor {
        private final String key;

        AuthInterceptor(String key) {
            this.key = "Bearer " + key;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().header("Authorization", this.key).build();
            return chain.proceed(request);
        }
    }

    static final class BuilderImpl
    implements LuckPermsRestClient.Builder {
        private String baseUrl = null;
        private String apiKey = null;
        private Consumer<OkHttpClient.Builder> clientConfigurer = null;

        BuilderImpl() {
        }

        @Override
        public LuckPermsRestClient.Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Override
        public LuckPermsRestClient.Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public LuckPermsRestClient.Builder httpClientConfigurer(Consumer<OkHttpClient.Builder> clientConfigurer) {
            this.clientConfigurer = clientConfigurer;
            return this;
        }

        @Override
        public LuckPermsRestClient build() {
            Objects.requireNonNull(this.baseUrl, "baseUrl must be configured!");
            return new LuckPermsRestClientImpl(this.baseUrl, this.apiKey, this.clientConfigurer);
        }
    }
}

