/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Objects;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;
import net.ltgt.oidc.servlet.NullLoggedOutSessionStore;
import net.ltgt.oidc.servlet.SessionInfo;
import net.ltgt.oidc.servlet.SimpleUserPrincipal;
import net.ltgt.oidc.servlet.UserPrincipal;
import net.ltgt.oidc.servlet.UserPrincipalFactory;
import org.jspecify.annotations.Nullable;

public class UserFilter
extends HttpFilter {
    private UserPrincipalFactory userPrincipalFactory;
    private LoggedOutSessionStore loggedOutSessionStore;

    public UserFilter() {
    }

    public UserFilter(UserPrincipalFactory userPrincipalFactory) {
        this(userPrincipalFactory, null);
    }

    public UserFilter(UserPrincipalFactory userPrincipalFactory, @Nullable LoggedOutSessionStore loggedOutSessionStore) {
        this.userPrincipalFactory = Objects.requireNonNull(userPrincipalFactory);
        this.loggedOutSessionStore = loggedOutSessionStore != null ? loggedOutSessionStore : NullLoggedOutSessionStore.INSTANCE;
    }

    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        if (this.userPrincipalFactory == null) {
            this.userPrincipalFactory = (UserPrincipalFactory)this.getServletContext().getAttribute(UserPrincipalFactory.CONTEXT_ATTRIBUTE_NAME);
        }
        if (this.userPrincipalFactory == null) {
            this.userPrincipalFactory = SimpleUserPrincipal.FACTORY;
        }
        if (this.loggedOutSessionStore == null) {
            this.loggedOutSessionStore = (LoggedOutSessionStore)this.getServletContext().getAttribute(LoggedOutSessionStore.CONTEXT_ATTRIBUTE_NAME);
        }
        if (this.loggedOutSessionStore == null) {
            this.loggedOutSessionStore = NullLoggedOutSessionStore.INSTANCE;
        }
    }

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        SessionInfo sessionInfo;
        HttpSession session = req.getSession(false);
        if (req.getUserPrincipal() == null && session != null && (sessionInfo = (SessionInfo)session.getAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME)) != null) {
            if (sessionInfo.getIDTokenClaims().getSessionID() != null && this.loggedOutSessionStore.isLoggedOut(sessionInfo.getIDTokenClaims().getSessionID())) {
                session.invalidate();
            } else {
                UserPrincipal userPrincipal = this.userPrincipalFactory.createUserPrincipal(sessionInfo, session);
                req = this.wrapRequest(req, userPrincipal);
            }
        }
        super.doFilter(req, res, chain);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest req, final UserPrincipal userPrincipal) {
        return new HttpServletRequestWrapper(this, req){

            public String getRemoteUser() {
                return userPrincipal.getName();
            }

            public Principal getUserPrincipal() {
                return userPrincipal;
            }

            public boolean isUserInRole(String role) {
                return userPrincipal.hasRole(role);
            }
        };
    }
}

