/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.Serializable;
import java.util.Objects;
import net.minidev.json.JSONObject;

public final class SessionInfo
implements Serializable {
    static final String SESSION_ATTRIBUTE_NAME = SessionInfo.class.getName();
    private final OIDCTokens oidcTokens;
    private final IDTokenClaimsSet idTokenClaims;
    private final UserInfo userInfo;

    public SessionInfo(OIDCTokens oidcTokens, IDTokenClaimsSet idTokenClaims, UserInfo userInfo) {
        this.oidcTokens = Objects.requireNonNull(oidcTokens);
        this.idTokenClaims = Objects.requireNonNull(idTokenClaims);
        this.userInfo = Objects.requireNonNull(userInfo);
    }

    public OIDCTokens getOIDCTokens() {
        return this.oidcTokens;
    }

    public IDTokenClaimsSet getIDTokenClaims() {
        return this.idTokenClaims;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    private Object writeReplace() {
        return new SerializableSessionInfo(this.oidcTokens.toJSONObject().toJSONString(), this.userInfo.toJSONString());
    }

    private record SerializableSessionInfo(String serializedOidcTokens, String serializedUserInfo) implements Serializable
    {
        Object readResolve() {
            try {
                OIDCTokens oidcTokens = OIDCTokens.parse((JSONObject)JSONObjectUtils.parse((String)this.serializedOidcTokens()));
                UserInfo userInfo = UserInfo.parse((String)this.serializedUserInfo());
                return new SessionInfo(oidcTokens, new IDTokenClaimsSet(oidcTokens.getIDToken().getJWTClaimsSet()), userInfo);
            }
            catch (ParseException | java.text.ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

