/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.nimbusds.oauth2.sdk.id.State;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import net.ltgt.oidc.servlet.LogoutState;
import net.ltgt.oidc.servlet.Utils;

public class LogoutCallbackServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!Utils.isNavigation(req)) {
            resp.sendError(400, "Not a navigation request");
        }
        State stateParam = State.parse((String)req.getParameter("state"));
        LogoutState logoutState = Optional.ofNullable(req.getSession(false)).map(session -> {
            LogoutState state = (LogoutState)session.getAttribute(LogoutState.SESSION_ATTRIBUTE_NAME);
            session.removeAttribute(LogoutState.SESSION_ATTRIBUTE_NAME);
            return state;
        }).orElse(null);
        if (logoutState == null) {
            resp.sendError(400, "Missing saved state from logout request initiation");
            return;
        }
        if (!Objects.equals(stateParam, logoutState.state())) {
            resp.sendError(400, "State mismatch");
            return;
        }
        Utils.sendRedirect(resp, logoutState.requestUri());
    }
}

