/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;

public class InMemoryLoggedOutSessionStore
implements LoggedOutSessionStore {
    private final ConcurrentMap<SessionID, Set<String>> loggedInSessions = new ConcurrentSkipListMap<SessionID, Set<String>>();

    @Override
    public void logout(SessionID sessionID) {
        Set loggedOutSessions = (Set)this.loggedInSessions.remove(sessionID);
        this.doLogout(loggedOutSessions);
    }

    @ForOverride
    protected void doLogout(Set<String> sessionIds) {
    }

    @Override
    public boolean isLoggedOut(SessionID sessionID) {
        return this.loggedInSessions.getOrDefault(sessionID, Set.of()).isEmpty();
    }

    @Override
    public void acquire(SessionID sessionID, String sessionId) {
        this.loggedInSessions.compute(sessionID, (ignored, old) -> old == null ? Set.of(sessionId) : Stream.concat(old.stream(), Stream.of(sessionId)).collect(Collectors.toUnmodifiableSet()));
    }

    @Override
    public void release(SessionID sessionID, String sessionId) {
        this.loggedInSessions.compute(sessionID, (ignored, old) -> {
            if (old == null) {
                return null;
            }
            if (!old.contains(sessionId)) {
                return old;
            }
            if (old.size() == 1) {
                return null;
            }
            return old.stream().filter(Predicate.not(sessionId::equals)).collect(Collectors.toUnmodifiableSet());
        });
    }

    @Override
    public void renew(SessionID sessionID, String oldSessionId, String newSessionId) {
        this.loggedInSessions.compute(sessionID, (ignored, old) -> {
            if (old == null) {
                return Set.of(newSessionId);
            }
            return Stream.concat(old.stream().filter(Predicate.not(oldSessionId::equals)), Stream.of(newSessionId)).collect(Collectors.toUnmodifiableSet());
        });
    }
}

