/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Objects;
import net.ltgt.oidc.servlet.AbstractAuthorizationFilter;
import net.ltgt.oidc.servlet.AuthenticationRedirector;
import net.ltgt.oidc.servlet.UserPrincipal;

public class HasRoleFilter
extends AbstractAuthorizationFilter {
    public static final String ROLE = "role";
    private String role;

    public HasRoleFilter() {
    }

    public HasRoleFilter(String role) {
        this.role = Objects.requireNonNull(role);
    }

    public HasRoleFilter(AuthenticationRedirector authenticationRedirector) {
        super(authenticationRedirector);
    }

    public HasRoleFilter(AuthenticationRedirector authenticationRedirector, String role) {
        super(authenticationRedirector);
        this.role = Objects.requireNonNull(role);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        super.init();
        if (this.role == null) {
            this.role = Objects.requireNonNull(this.getInitParameter(ROLE));
        }
    }

    @Override
    protected final boolean isAuthorized(HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        if (principal instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)principal;
            return userPrincipal.hasRole(this.role);
        }
        return false;
    }
}

