/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;

public class Utils {
    public static final String RETURN_TO_PARAMETER_NAME = "return-to";

    private Utils() {
    }

    static void sendRedirect(HttpServletResponse res, String location) {
        res.resetBuffer();
        res.setHeader("Location", location);
        res.setStatus(303);
    }

    static boolean isNavigation(HttpServletRequest req) {
        String fetchMode = req.getHeader("Sec-Fetch-Mode");
        return fetchMode == null || fetchMode.equals("navigate");
    }

    static boolean isSafeMethod(HttpServletRequest req) {
        return req.getMethod().equalsIgnoreCase("GET") || req.getMethod().equalsIgnoreCase("HEAD");
    }

    static boolean isSameOrigin(HttpServletRequest req) {
        String fetchSite = req.getHeader("Sec-Fetch-Site");
        if (fetchSite != null && fetchSite.equals("same-origin")) {
            return true;
        }
        Object actualOrigin = req.getHeader("Origin");
        if (actualOrigin == null) {
            try {
                actualOrigin = URI.create(req.getHeader("Referer")).resolve("/").toString();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return false;
            }
        } else {
            actualOrigin = (String)actualOrigin + "/";
        }
        return req.getRequestURL().toString().startsWith((String)actualOrigin);
    }

    static String getReturnToParameter(HttpServletRequest req) {
        URI returnToUri;
        String returnTo = req.getParameter(RETURN_TO_PARAMETER_NAME);
        if (returnTo == null) {
            return "/";
        }
        URI rootUri = URI.create(req.getRequestURL().toString()).resolve("/");
        URI relativized = rootUri.relativize(returnToUri = rootUri.resolve(returnTo));
        if (relativized.equals(returnToUri)) {
            return "/";
        }
        return "/" + relativized.toASCIIString();
    }

    public static String getRequestUri(HttpServletRequest req) {
        String queryString;
        String requestUri;
        if (req.getDispatcherType() == DispatcherType.FORWARD) {
            requestUri = (String)req.getAttribute("jakarta.servlet.forward.request_uri");
            queryString = (String)req.getAttribute("jakarta.servlet.forward.query_string");
        } else {
            requestUri = req.getRequestURI();
            queryString = req.getQueryString();
        }
        return queryString == null ? requestUri : requestUri + "?" + queryString;
    }
}

