/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.ltgt.oidc.servlet.SessionInfo;
import net.ltgt.oidc.servlet.UserPrincipal;
import net.ltgt.oidc.servlet.UserPrincipalFactory;

public class KeycloakUserPrincipal
implements UserPrincipal {
    public static final UserPrincipalFactory FACTORY = (sessionInfo, unused) -> new KeycloakUserPrincipal(sessionInfo);
    private final SessionInfo sessionInfo;

    public KeycloakUserPrincipal(SessionInfo sessionInfo) {
        this.sessionInfo = Objects.requireNonNull(sessionInfo);
    }

    @Override
    public boolean hasRole(String role) {
        return Optional.ofNullable(this.sessionInfo.getUserInfo().getJSONObjectClaim("realm_access")).map(realmAccess -> (Collection)realmAccess.get((Object)"roles")).map(roles -> roles.contains(role)).orElse(false);
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

