/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.ltgt.oidc.servlet.AuthenticationState;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.SessionInfo;
import net.ltgt.oidc.servlet.SimpleUserPrincipal;
import net.ltgt.oidc.servlet.UserPrincipalFactory;
import net.ltgt.oidc.servlet.Utils;
import org.jspecify.annotations.Nullable;

public class CallbackServlet
extends HttpServlet {
    private Configuration configuration;
    private UserPrincipalFactory userPrincipalFactory;
    private IDTokenValidator idTokenValidator;

    public CallbackServlet() {
    }

    public CallbackServlet(Configuration configuration, UserPrincipalFactory userPrincipalFactory) {
        this.configuration = Objects.requireNonNull(configuration);
        this.userPrincipalFactory = Objects.requireNonNull(userPrincipalFactory);
    }

    public void init() throws ServletException {
        if (this.configuration == null) {
            this.configuration = (Configuration)this.getServletContext().getAttribute(Configuration.CONTEXT_ATTRIBUTE_NAME);
        }
        Objects.requireNonNull(this.configuration, "configuration");
        if (this.userPrincipalFactory == null) {
            this.userPrincipalFactory = (UserPrincipalFactory)this.getServletContext().getAttribute(UserPrincipalFactory.CONTEXT_ATTRIBUTE_NAME);
        }
        if (this.userPrincipalFactory == null) {
            this.userPrincipalFactory = SimpleUserPrincipal.FACTORY;
        }
        try {
            this.idTokenValidator = new IDTokenValidator(this.configuration.getProviderMetadata().getIssuer(), this.configuration.getClientAuthentication().getClientID(), (JWSKeySelector)new JWSVerificationKeySelector(Set.copyOf(this.configuration.getProviderMetadata().getIDTokenJWSAlgs()), JWKSourceBuilder.create((URL)this.configuration.getProviderMetadata().getJWKSetURI().toURL()).build()), null);
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserInfoResponse userInfoResponse;
        IDTokenClaimsSet idTokenClaims;
        TokenResponse tokenResponse;
        AuthenticationResponse response;
        if (!Utils.isNavigation(req)) {
            this.sendError(resp, 400, "Not a navigation request", null);
        }
        try {
            response = AuthenticationResponseParser.parse((HTTPRequest)JakartaServletUtils.createHTTPRequest((HttpServletRequest)req));
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            this.sendError(resp, 400, "Error parsing parameters", e);
            return;
        }
        AuthenticationState authenticationState = Optional.ofNullable(req.getSession(false)).map(session -> {
            AuthenticationState state = (AuthenticationState)session.getAttribute(AuthenticationState.SESSION_ATTRIBUTE_NAME);
            session.removeAttribute(AuthenticationState.SESSION_ATTRIBUTE_NAME);
            return state;
        }).orElse(null);
        if (authenticationState == null) {
            this.sendError(resp, 400, "Missing saved state from authorization request initiation", null);
            return;
        }
        if (!Objects.equals(response.getState(), authenticationState.state())) {
            this.sendError(resp, 400, "State mismatch", null);
            return;
        }
        if (!response.indicatesSuccess()) {
            this.sendError(resp, 400, response.toErrorResponse().getErrorObject().getCode(), null);
            return;
        }
        AuthorizationCode code = response.toSuccessResponse().getAuthorizationCode();
        TokenRequest tokenRequest = new TokenRequest.Builder(this.configuration.getProviderMetadata().getTokenEndpointURI(), this.configuration.getClientAuthentication(), (AuthorizationGrant)new AuthorizationCodeGrant(code, URI.create(req.getRequestURL().toString()), authenticationState.codeVerifier())).build();
        try {
            tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | IOException e) {
            this.sendError(resp, 500, "Error in token request", e);
            return;
        }
        if (!tokenResponse.indicatesSuccess()) {
            this.sendError(resp, 500, "Token request returned error: " + String.valueOf(tokenResponse.toErrorResponse().getErrorObject()), null);
            return;
        }
        OIDCTokenResponse successResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
        try {
            idTokenClaims = this.idTokenValidator.validate(successResponse.getOIDCTokens().getIDToken(), authenticationState.nonce());
        }
        catch (BadJOSEException e) {
            this.sendError(resp, 500, "Error validating ID Token", e);
            return;
        }
        catch (JOSEException e) {
            this.sendError(resp, 500, "Invalid ID Token", e);
            return;
        }
        UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.getProviderMetadata().getUserInfoEndpointURI(), successResponse.getOIDCTokens().getAccessToken());
        try {
            userInfoResponse = UserInfoResponse.parse((HTTPResponse)userInfoRequest.toHTTPRequest().send());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | IOException e) {
            this.sendError(resp, 500, "Error in User Info request", e);
            return;
        }
        if (!userInfoResponse.indicatesSuccess()) {
            this.sendError(resp, 500, "User Info request returned error: " + userInfoResponse.toErrorResponse().getErrorObject().getCode(), null);
            return;
        }
        UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
        if (userInfo == null) {
            try {
                userInfo = new UserInfo(userInfoResponse.toSuccessResponse().getUserInfoJWT().getJWTClaimsSet());
            }
            catch (ParseException e) {
                this.sendError(resp, 500, "Error parsing ID Token claims", e);
                return;
            }
        }
        req.changeSessionId();
        SessionInfo sessionInfo = new SessionInfo(successResponse.getOIDCTokens(), idTokenClaims, userInfo);
        HttpSession session2 = req.getSession();
        session2.setAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME, (Object)sessionInfo);
        this.userPrincipalFactory.userAuthenticated(sessionInfo, session2);
        Utils.sendRedirect(resp, authenticationState.requestUri());
    }

    @ForOverride
    protected void sendError(HttpServletResponse resp, int statusCode, String message, @Nullable Throwable cause) throws IOException, ServletException {
        if (cause != null) {
            this.log(message, cause);
        }
        resp.sendError(statusCode, message);
    }
}

