/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.LoggedOutSessionStore;
import net.ltgt.oidc.servlet.SessionInfo;
import net.ltgt.oidc.servlet.UserPrincipal;
import org.jspecify.annotations.Nullable;

public class UserFilter
extends HttpFilter {
    private Configuration configuration;
    private @Nullable LoggedOutSessionStore loggedOutSessionStore;

    public void init() throws ServletException {
        this.configuration = (Configuration)this.getServletContext().getAttribute(Configuration.CONTEXT_ATTRIBUTE_NAME);
        this.loggedOutSessionStore = (LoggedOutSessionStore)this.getServletContext().getAttribute(LoggedOutSessionStore.CONTEXT_ATTRIBUTE_NAME);
    }

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        SessionInfo sessionInfo;
        HttpSession session = req.getSession(false);
        if (session != null && (sessionInfo = (SessionInfo)session.getAttribute(SessionInfo.SESSION_ATTRIBUTE_NAME)) != null) {
            if (this.loggedOutSessionStore != null && sessionInfo.getIDTokenClaims().getSessionID() != null && this.loggedOutSessionStore.isLoggedOut(sessionInfo.getIDTokenClaims().getSessionID())) {
                session.invalidate();
            } else {
                req = this.wrapRequest(req, sessionInfo);
            }
        }
        super.doFilter(req, res, chain);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest req, final SessionInfo sessionInfo) {
        return new HttpServletRequestWrapper(req){
            private final UserPrincipal userPrincipal;
            {
                super(arg0);
                this.userPrincipal = UserFilter.this.configuration.createUserPrincipal(sessionInfo);
            }

            public String getRemoteUser() {
                return this.userPrincipal.getName();
            }

            public Principal getUserPrincipal() {
                return this.userPrincipal;
            }

            public boolean isUserInRole(String role) {
                return this.userPrincipal.hasRole(role);
            }
        };
    }
}

