/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.ltgt.oidc.servlet.AuthenticationRedirector;
import net.ltgt.oidc.servlet.Utils;

public class LoginServlet
extends HttpServlet {
    private AuthenticationRedirector authenticationRedirector;

    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        this.authenticationRedirector = (AuthenticationRedirector)this.getServletContext().getAttribute(AuthenticationRedirector.CONTEXT_ATTRIBUTE_NAME);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!Utils.isNavigation(req)) {
            resp.sendError(400);
            return;
        }
        String returnTo = Utils.getReturnToParameter(req);
        if (!Utils.isSameOrigin(req)) {
            Utils.sendRedirect(resp, returnTo);
            return;
        }
        if (req.getUserPrincipal() != null) {
            Utils.sendRedirect(resp, returnTo);
            return;
        }
        this.authenticationRedirector.redirectToAuthenticationEndpoint(req, resp, returnTo, builder -> this.configureAuthenticationRequest(req, (AuthenticationRequest.Builder)builder));
    }

    @ForOverride
    protected void configureAuthenticationRequest(HttpServletRequest req, AuthenticationRequest.Builder builder) {
    }
}

