/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import net.ltgt.oidc.servlet.AbstractAuthorizationFilter;

public class HasRoleFilter
extends AbstractAuthorizationFilter {
    public static final String ROLE = "role";
    private String role;

    public HasRoleFilter() {
    }

    public HasRoleFilter(String role) {
        this.role = role;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        super.init();
        if (this.role == null) {
            this.role = Objects.requireNonNull(this.getInitParameter(ROLE));
        }
    }

    @Override
    protected final boolean isAuthorized(HttpServletRequest req) {
        return req.isUserInRole(this.role);
    }

    @Override
    @ForOverride
    protected void redirectToAuthenticationEndpoint(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (req.getUserPrincipal() == null) {
            this.doRedirectToAuthenticationEndpoint(req, res);
        } else {
            this.sendForbidden(req, res);
        }
    }

    protected final void doRedirectToAuthenticationEndpoint(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        super.redirectToAuthenticationEndpoint(req, res);
    }

    @Override
    @ForOverride
    protected void sendUnauthorized(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (req.getUserPrincipal() == null) {
            this.doSendUnauthorized(req, res);
        } else {
            this.sendForbidden(req, res);
        }
    }

    protected final void doSendUnauthorized(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        super.sendUnauthorized(req, res);
    }

    @ForOverride
    protected void sendForbidden(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.sendError(403);
    }
}

