/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.function.Consumer;
import net.ltgt.oidc.servlet.AuthenticationState;
import net.ltgt.oidc.servlet.Configuration;
import net.ltgt.oidc.servlet.Utils;
import org.jspecify.annotations.Nullable;

public class AuthenticationRedirector {
    public static final String CONTEXT_ATTRIBUTE_NAME = AuthenticationRedirector.class.getName();
    private final Configuration configuration;
    private final String callbackPath;

    public AuthenticationRedirector(Configuration configuration, String callbackPath) {
        this.configuration = configuration;
        this.callbackPath = callbackPath;
    }

    public void redirectToAuthenticationEndpoint(HttpServletRequest req, HttpServletResponse res, String returnTo) {
        this.redirectToAuthenticationEndpoint(req, res, returnTo, null);
    }

    public void redirectToAuthenticationEndpoint(HttpServletRequest req, HttpServletResponse res, String returnTo, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    AuthenticationRequest.Builder> configureAuthenticationRequest) {
        State state = new State();
        Nonce nonce = new Nonce();
        CodeVerifier codeVerifier = new CodeVerifier();
        req.getSession().setAttribute(AuthenticationState.SESSION_ATTRIBUTE_NAME, (Object)new AuthenticationState(state, nonce, codeVerifier, returnTo));
        AuthenticationRequest.Builder authenticationRequestBuilder = new AuthenticationRequest.Builder(ResponseType.CODE, new Scope(new Scope.Value[]{OIDCScopeValue.OPENID, OIDCScopeValue.PROFILE, OIDCScopeValue.EMAIL}), this.configuration.getClientAuthentication().getClientID(), URI.create(req.getRequestURL().toString()).resolve(this.callbackPath));
        if (configureAuthenticationRequest != null) {
            configureAuthenticationRequest.accept(authenticationRequestBuilder);
        }
        this.configureAuthenticationRequest(authenticationRequestBuilder);
        authenticationRequestBuilder.endpointURI(this.configuration.getProviderMetadata().getAuthorizationEndpointURI()).state(state).nonce(nonce).codeChallenge(codeVerifier, CodeChallengeMethod.S256);
        Utils.sendRedirect(res, authenticationRequestBuilder.build().toURI().toASCIIString());
    }

    @ForOverride
    protected void configureAuthenticationRequest(AuthenticationRequest.Builder authenticationRequestBuilder) {
    }
}

