/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.oidc.servlet;

import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import net.ltgt.oidc.servlet.AuthenticationRedirector;
import net.ltgt.oidc.servlet.BackchannelLogoutServlet;
import net.ltgt.oidc.servlet.CallbackServlet;
import net.ltgt.oidc.servlet.Utils;

public abstract class AbstractAuthorizationFilter
extends HttpFilter {
    public static final String IS_PRIVATE_REQUEST_ATTRIBUTE_NAME = AbstractAuthorizationFilter.class.getName() + ".is_private";
    private AuthenticationRedirector authenticationRedirector;

    @OverridingMethodsMustInvokeSuper
    public void init() throws ServletException {
        this.authenticationRedirector = (AuthenticationRedirector)this.getServletContext().getAttribute(AuthenticationRedirector.CONTEXT_ATTRIBUTE_NAME);
    }

    @ForOverride
    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.isAuthorized(req) || this.isCallbackServlet(req)) {
            req.setAttribute(IS_PRIVATE_REQUEST_ATTRIBUTE_NAME, (Object)true);
            super.doFilter(req, res, chain);
            return;
        }
        if (Utils.isNavigation(req) && Utils.isSafeMethod(req)) {
            this.redirectToAuthenticationEndpoint(req, res);
            return;
        }
        this.sendUnauthorized(req, res);
    }

    protected abstract boolean isAuthorized(HttpServletRequest var1);

    @ForOverride
    protected boolean isCallbackServlet(HttpServletRequest req) {
        Class<?> servletClass;
        try {
            servletClass = Class.forName(Objects.requireNonNull((ServletRegistration)req.getServletContext().getServletRegistrations().get(req.getHttpServletMapping().getServletName())).getClassName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return CallbackServlet.class.isAssignableFrom(servletClass) || BackchannelLogoutServlet.class.isAssignableFrom(servletClass);
    }

    @ForOverride
    protected void redirectToAuthenticationEndpoint(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.authenticationRedirector.redirectToAuthenticationEndpoint(req, res, Utils.getRequestUri(req), builder -> this.configureAuthenticationRequest(req, (AuthenticationRequest.Builder)builder));
    }

    @ForOverride
    protected void configureAuthenticationRequest(HttpServletRequest req, AuthenticationRequest.Builder builder) {
    }

    @ForOverride
    protected void sendUnauthorized(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.sendError(401);
    }
}

