/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.resteasy.testing;

import java.net.URI;
import java.security.Principal;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import net.ltgt.resteasy.testing.InProcessClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.junit.rules.ExternalResource;

public class InProcessResteasy
extends ExternalResource {
    private static final URI DEFAULT_BASE_URI = URI.create("http://localhost/");
    private final URI baseUri;
    private final UriBuilder baseUriBuilder;
    private ResteasyDeployment deployment;
    private Client client;

    public InProcessResteasy() {
        this(DEFAULT_BASE_URI);
    }

    public InProcessResteasy(URI baseUri) {
        this.baseUri = baseUri;
        this.baseUriBuilder = UriBuilder.fromUri((URI)baseUri);
    }

    public final URI getBaseUri() {
        return this.baseUri;
    }

    public final UriBuilder getBaseUriBuilder() {
        return this.baseUriBuilder.clone();
    }

    public final ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public final Client getClient() {
        return this.client;
    }

    protected final void before() throws Throwable {
        this.deployment = new ResteasyDeployment();
        this.deployment.getDefaultContextObjects().put(SecurityContext.class, new DummySecurityContext());
        this.configureDeployment(this.deployment);
        this.deployment.start();
        ResteasyClientBuilder builder = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new InProcessClientHttpEngine(this.deployment.getDispatcher(), this.baseUri));
        this.configureClient(builder);
        this.client = builder.build();
    }

    protected final void after() {
        this.deployment.stop();
        this.client.close();
    }

    protected void configureDeployment(ResteasyDeployment deployment) {
    }

    protected void configureClient(ResteasyClientBuilder builder) {
    }

    private static class DummySecurityContext
    implements SecurityContext {
        private DummySecurityContext() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }
}

