/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.resteasy.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.CookieParser;

public class InProcessClientHttpEngine
implements ClientHttpEngine {
    private final Dispatcher dispatcher;
    private final URI baseUri;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;

    public InProcessClientHttpEngine(Dispatcher dispatcher, URI baseUri) {
        this.dispatcher = dispatcher;
        this.baseUri = baseUri;
    }

    public ClientResponse invoke(ClientInvocation request) {
        MockHttpRequest mockRequest = this.createRequest(request);
        MockHttpResponse mockResponse = new MockHttpResponse();
        this.dispatcher.invoke((HttpRequest)mockRequest, (HttpResponse)mockResponse);
        return this.createResponse(request, mockResponse);
    }

    private MockHttpRequest createRequest(ClientInvocation request) {
        MockHttpRequest mockRequest = MockHttpRequest.create((String)request.getMethod(), (URI)request.getUri(), (URI)this.baseUri);
        if (request.getEntity() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
            try {
                request.writeRequestBody(request.getEntityStream());
                baos.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            mockRequest.setInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        MultivaluedMap requestHeaders = request.getHeaders().asMap();
        mockRequest.getMutableHeaders().putAll((Map)requestHeaders);
        this.copyCookies(mockRequest, (MultivaluedMap<String, String>)requestHeaders);
        return mockRequest;
    }

    private void copyCookies(MockHttpRequest mockRequest, MultivaluedMap<String, String> requestHeaders) {
        List cookieHeaders = (List)requestHeaders.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return;
        }
        for (String cookieHeader : cookieHeaders) {
            for (Cookie cookie : CookieParser.parseCookies((String)cookieHeader)) {
                mockRequest.cookie(cookie.getName(), cookie.getValue());
            }
        }
    }

    private ClientResponse createResponse(ClientInvocation request, final MockHttpResponse mockResponse) {
        ClientResponse response = new ClientResponse(request.getClientConfiguration()){
            private InputStream inputStream;

            protected InputStream getInputStream() {
                if (this.inputStream == null) {
                    this.inputStream = new ByteArrayInputStream(mockResponse.getOutput());
                }
                return this.inputStream;
            }

            protected void setInputStream(InputStream is) {
                this.inputStream = is;
            }

            public void releaseConnection() throws IOException {
            }
        };
        response.setStatus(mockResponse.getStatus());
        response.setHeaders(this.transformHeaders((MultivaluedMap<String, Object>)mockResponse.getOutputHeaders(), mockResponse.getNewCookies()));
        return response;
    }

    private MultivaluedMap<String, String> transformHeaders(MultivaluedMap<String, Object> outputHeaders, List<NewCookie> newCookies) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Map.Entry header : outputHeaders.entrySet()) {
            for (Object value : (List)header.getValue()) {
                headers.add(header.getKey(), (Object)this.dispatcher.getProviderFactory().toHeaderString(value));
            }
        }
        for (NewCookie newCookie : newCookies) {
            headers.add((Object)"Set-Cookie", (Object)this.dispatcher.getProviderFactory().toHeaderString((Object)newCookie));
        }
        return headers;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void close() {
    }
}

