/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.jaxrs.webhook.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.Priority;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.ltgt.jaxrs.webhook.Util;
import net.ltgt.jaxrs.webhook.server.HasWebhookSecret;
import net.ltgt.jaxrs.webhook.server.Webhook;

@Provider
@Priority(value=2000)
@Webhook
public class WebhookSignatureFilter
implements ContainerRequestFilter {
    private final byte[] secret;

    public WebhookSignatureFilter() {
        this.secret = null;
    }

    public WebhookSignatureFilter(String secret) {
        if (secret.isEmpty()) {
            throw new IllegalArgumentException("secret must not be empty");
        }
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public WebhookSignatureFilter(byte[] secret) {
        if (secret.length == 0) {
            throw new IllegalArgumentException("secret must not be empty");
        }
        this.secret = secret;
    }

    protected byte[] getSecret(ContainerRequestContext requestContext) {
        if (this.secret != null) {
            return this.secret;
        }
        return ((HasWebhookSecret)requestContext.getUriInfo().getMatchedResources().get(0)).getWebhookSecret();
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Mac mac;
        byte[] secret = this.getSecret(requestContext);
        if (secret == null || secret.length == 0) {
            throw new IllegalStateException("Webhook secret may not be null or empty");
        }
        List expectedSignatures = (List)requestContext.getHeaders().get((Object)"X-Hub-Signature");
        if (expectedSignatures == null || expectedSignatures.size() != 1) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        String expectedSignature = (String)expectedSignatures.get(0);
        if (!expectedSignature.startsWith("sha1=")) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        expectedSignature = expectedSignature.substring("sha1=".length());
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        byte[] bytes = Util.toByteArray(requestContext.getEntityStream());
        byte[] actualSignature = mac.doFinal(bytes);
        if (!expectedSignature.equalsIgnoreCase(Util.hex(actualSignature))) {
            requestContext.abortWith(Response.ok().build());
            return;
        }
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }
}

