/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.jaxrs.webhook.client;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Priority;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import net.ltgt.jaxrs.webhook.Util;

@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=3000)
public class WebhookSignatureFilter
implements WriterInterceptor {
    private final byte[] secret;

    public WebhookSignatureFilter(String secret) {
        if (secret.isEmpty()) {
            throw new IllegalArgumentException("secret must not be empty");
        }
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public WebhookSignatureFilter(byte[] secret) {
        if (secret.length == 0) {
            throw new IllegalArgumentException("secret must not be empty");
        }
        this.secret = secret;
    }

    protected WebhookSignatureFilter() {
        this.secret = null;
    }

    protected byte[] getSecret(WriterInterceptorContext context) {
        return this.secret;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Mac mac;
        byte[] secret = this.getSecret(context);
        if (secret == null || secret.length == 0) {
            return;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        OutputStream realOut = context.getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        context.setOutputStream((OutputStream)new FilterOutputStream(baos){

            @Override
            public void write(int b) throws IOException {
                mac.update((byte)b);
                this.out.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                mac.update(b);
                this.out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                mac.update(b, off, len);
                this.out.write(b, off, len);
            }
        });
        context.proceed();
        byte[] signature = mac.doFinal();
        context.getHeaders().putSingle((Object)"X-Hub-Signature", (Object)("sha1=" + Util.hex(signature)));
        realOut.write(baos.toByteArray());
        baos = null;
    }
}

