/*
 * Decompiled with CFR 0.152.
 */
package net.lizhao.scriq.eval;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.lizhao.scriq.eval.NDA;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\r\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0015H\u0016J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\b\u0010&\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lnet/lizhao/scriq/eval/Value;", "", "value", "(Ljava/lang/Object;)V", "isDouble", "", "()Z", "isFuture", "isList", "isNDA", "isString", "getValue", "()Ljava/lang/Object;", "asBoolean", "()Ljava/lang/Boolean;", "asDouble", "", "()Ljava/lang/Double;", "asFuture", "Ljava/util/concurrent/CompletableFuture;", "asInt", "", "()Ljava/lang/Integer;", "asList", "", "asNDA", "Lnet/lizhao/scriq/eval/NDA;", "asString", "", "div", "right", "equals", "o", "hashCode", "minus", "plus", "rem", "times", "toString", "Companion", "scriq"})
@SourceDebugExtension(value={"SMAP\nValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Value.kt\nnet/lizhao/scriq/eval/Value\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object value;
    @NotNull
    private static Value VOID = new Value(new Object());

    public Value(@Nullable Object value) {
        this.value = value;
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    @Nullable
    public final Integer asInt() {
        Object object = this.value;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        return (int)((Double)object).doubleValue();
    }

    @Nullable
    public final Boolean asBoolean() {
        return (Boolean)this.value;
    }

    @Nullable
    public final Double asDouble() {
        return (Double)this.value;
    }

    @NotNull
    public final String asString() {
        return String.valueOf(this.value);
    }

    @NotNull
    public final List<Object> asList() {
        List list = CollectionsKt.listOf((Object)this.value);
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        return list;
    }

    @Nullable
    public final CompletableFuture<Object> asFuture() {
        return (CompletableFuture)this.value;
    }

    @NotNull
    public final NDA asNDA() {
        Object object = this.value;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.lizhao.scriq.eval.NDA");
        return (NDA)object;
    }

    public final boolean isDouble() {
        return this.value instanceof Double;
    }

    public final boolean isString() {
        return this.value instanceof String;
    }

    public final boolean isFuture() {
        return this.value instanceof CompletableFuture;
    }

    public final boolean isList() {
        return this.value instanceof List;
    }

    public final boolean isNDA() {
        return this.value instanceof NDA;
    }

    public int hashCode() {
        Object object = this.value;
        return object != null ? object.hashCode() : 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this.value == o) {
            return true;
        }
        if (this.isDouble()) {
            boolean bl;
            if (o instanceof Number) {
                bl = Intrinsics.areEqual((Object)this.value, (Object)((Number)o).doubleValue());
            } else if (o instanceof String) {
                bl = Intrinsics.areEqual((Object)this.value, (Object)Double.parseDouble((String)o));
            } else {
                Value value = (Value)o;
                Intrinsics.checkNotNull((Object)value);
                bl = Intrinsics.areEqual((Object)this.value, (Object)value.value);
            }
            return bl;
        }
        if (this.isString()) {
            return Intrinsics.areEqual((Object)this.value, (Object)o);
        }
        return this.value == null || o == null || !Intrinsics.areEqual(o.getClass(), this.getClass()) ? false : Intrinsics.areEqual((Object)this.value, (Object)((Value)o).value);
    }

    @NotNull
    public final Value rem(@NotNull Value right) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Double d2 = right.asDouble();
        if (d2 != null) {
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            Object object = this.value;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            d = (Double)object % it;
        } else {
            d = null;
        }
        Double d3 = d;
        return new Value(d3);
    }

    @NotNull
    public final Value plus(@NotNull Value right) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Object object = this.value;
        if (object instanceof Double) {
            if (right.value instanceof Double) {
                value = new Value(((Number)this.value).doubleValue() + ((Number)right.value).doubleValue());
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Object object2 = this.value;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
                value = new Value(stringBuilder.append((Double)object2).append(right.value).toString());
            }
        } else if (object instanceof String) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object3 = this.value;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            value = new Value(stringBuilder.append((String)object3).append(right).toString());
        } else if (object instanceof NDA) {
            Object object4 = this.value;
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type net.lizhao.scriq.eval.NDA");
            value = new Value(((NDA)object4).plus(right));
        } else {
            throw new RuntimeException("'+' doesn't support the type'");
        }
        return value;
    }

    @NotNull
    public final Value minus(@NotNull Value right) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Object object = this.value;
        if (object instanceof Double) {
            Double d;
            Double d2 = right.asDouble();
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                Object object2 = this.value;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
                d = (Double)object2 - it;
            } else {
                d = null;
            }
            Double d3 = d;
            value = new Value(d3);
        } else if (object instanceof NDA) {
            Object object3 = this.value;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type net.lizhao.scriq.eval.NDA");
            value = new Value(((NDA)object3).minus(right));
        } else {
            throw new RuntimeException("'-' doesn't support the type'");
        }
        return value;
    }

    @NotNull
    public final Value div(@NotNull Value right) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Object object = this.value;
        if (object instanceof Double) {
            Double d;
            Double d2 = right.asDouble();
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                Object object2 = this.value;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
                d = (Double)object2 / it;
            } else {
                d = null;
            }
            Double d3 = d;
            value = new Value(d3);
        } else if (object instanceof NDA) {
            Object object3 = this.value;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type net.lizhao.scriq.eval.NDA");
            value = new Value(((NDA)object3).div(right));
        } else {
            throw new RuntimeException("'/' doesn't support the type'");
        }
        return value;
    }

    @NotNull
    public final Value times(@NotNull Value right) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Object object = this.value;
        if (object instanceof Double) {
            Double d;
            Double d2 = right.asDouble();
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                Object object2 = this.value;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
                d = (Double)object2 * it;
            } else {
                d = null;
            }
            Double d3 = d;
            value = new Value(d3);
        } else if (object instanceof NDA) {
            Object object3 = this.value;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type net.lizhao.scriq.eval.NDA");
            value = new Value(((NDA)object3).times(right));
        } else {
            throw new RuntimeException("'*' doesn't support the type'");
        }
        return value;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/lizhao/scriq/eval/Value$Companion;", "", "()V", "VOID", "Lnet/lizhao/scriq/eval/Value;", "getVOID", "()Lnet/lizhao/scriq/eval/Value;", "setVOID", "(Lnet/lizhao/scriq/eval/Value;)V", "scriq"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Value getVOID() {
            return VOID;
        }

        public final void setVOID(@NotNull Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"<set-?>");
            VOID = value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

