/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.linksfield.cube.partnersdk.utils.Base64Utils;

public class SignatureUtils {
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final int KEYPAIR_LENGTH = 2048;

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, String priKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = Base64Utils.decodeFromString(priKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, String pubKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodeByte = Base64Utils.decodeFromString(pubKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodeByte));
    }

    public static String sign(String plain, String prikey) throws Exception {
        if (SignatureUtils.isEmpty(plain, prikey)) {
            throw new IllegalArgumentException("Private key and encrypted data cannot be empty");
        }
        PrivateKey privatekey = SignatureUtils.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, prikey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initSign(privatekey);
        signature.update(plain.getBytes(StandardCharsets.UTF_8));
        byte[] signed = signature.sign();
        return Base64Utils.encodeToString(signed);
    }

    public static boolean verify(String plain, String sign, String pubkey) throws Exception {
        if (SignatureUtils.isEmpty(plain, sign, pubkey)) {
            return false;
        }
        PublicKey publicKey = SignatureUtils.getPublicKeyFromX509(SIGN_TYPE_RSA, pubkey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initVerify(publicKey);
        signature.update(plain.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64Utils.decodeFromString(sign));
    }

    public static RsaKeyPair buildRsa() throws NoSuchAlgorithmException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(SIGN_TYPE_RSA);
        gen.initialize(2048);
        KeyPair keyPair = gen.generateKeyPair();
        PublicKey pubKey = keyPair.getPublic();
        PrivateKey priKey = keyPair.getPrivate();
        byte[] pubEncBytes = pubKey.getEncoded();
        byte[] priEncBytes = priKey.getEncoded();
        String pubEncBase64 = Base64Utils.encodeToString(pubEncBytes);
        String priEncBase64 = Base64Utils.encodeToString(priEncBytes);
        RsaKeyPair pair = new RsaKeyPair();
        pair.setPublicKey(pubEncBase64);
        pair.setPrivateKey(priEncBase64);
        return pair;
    }

    public static boolean isEmpty(String ... strings) {
        for (String string : strings) {
            if (!SignatureUtils.isEmpty(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty() || !SignatureUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static class RsaKeyPair {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RsaKeyPair)) {
                return false;
            }
            RsaKeyPair other = (RsaKeyPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$privateKey = this.getPrivateKey();
            String other$privateKey = other.getPrivateKey();
            return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RsaKeyPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureUtils.RsaKeyPair(publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ")";
        }
    }
}

