/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.proxy;

import java.util.function.Function;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.Enums;
import net.linksfield.cube.partnersdk.domain.SignatureBuilder;
import net.linksfield.cube.partnersdk.domain.SignatureBuilderV2;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.DomainSignatureEvent;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilder;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilderV2;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.ResponseBody;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.proxy.AbstractModuleImplementProxy;

public class AbstractModuleV2ImplementProxy
extends AbstractModuleImplementProxy {
    public AbstractModuleV2ImplementProxy(ServicesContainer servicesContainer) {
        super(servicesContainer, Enums.SIGN_TYPE.V2);
    }

    @Override
    protected ResponseBody execute(BaseRequest domain, Function<HttpRequest, HttpResponse> httpFunction) {
        SignatureBuilderV2 signatureBuilder = new SignatureBuilderV2(domain, this.servicesContainer);
        HttpRequestBuilder httpRequestBuilder = this.createRequestBuilder(domain).requestUrl();
        if (HttpMethod.GET.equals((Object)domain.getHttpMethod())) {
            httpRequestBuilder.queryParams();
        } else {
            httpRequestBuilder.body();
        }
        signatureBuilder.signature(httpRequestBuilder);
        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));
        httpRequestBuilder.headers(signature);
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse httpResponse = httpFunction.apply(httpRequest);
        return this.parseResponseBody(httpResponse);
    }

    @Override
    protected SignatureBuilder createSignatureBuilder(BaseRequest domain) {
        return new SignatureBuilderV2(domain, this.servicesContainer);
    }

    @Override
    protected HttpRequestBuilder createRequestBuilder(BaseRequest domain) {
        return new HttpRequestBuilderV2(domain, this.servicesContainer);
    }
}

