/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.proxy;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.Enums;
import net.linksfield.cube.partnersdk.domain.SignatureBuilder;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.DomainSignatureEvent;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilder;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.ResponseBody;
import net.linksfield.cube.partnersdk.rest.ResponseBodyString;
import net.linksfield.cube.partnersdk.rest.StatusCode;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.proxy.extend.IModuleExecutor;
import net.linksfield.cube.partnersdk.sdk.proxy.extend.ModuleExecute;
import net.linksfield.cube.partnersdk.utils.ReflectUtils;

public abstract class AbstractModuleImplementProxy
implements InvocationHandler {
    private Enums.SIGN_TYPE signType;
    protected ServicesContainer servicesContainer;
    protected Map<HttpMethod, Function<HttpRequest, HttpResponse>> httpFunctionMap;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        BaseRequest domain = (BaseRequest)args[0];
        ModuleExecute moduleExecute = method.getDeclaredAnnotation(ModuleExecute.class);
        if (moduleExecute != null) {
            Class<? extends IModuleExecutor> executorClass = moduleExecute.execute();
            IModuleExecutor moduleExecutor = ReflectUtils.newInstance(executorClass);
            return moduleExecutor.execute(this.signType, domain, this.servicesContainer);
        }
        return this.execute(domain, this.httpFunctionMap.get((Object)domain.getHttpMethod()));
    }

    public AbstractModuleImplementProxy(ServicesContainer servicesContainer, Enums.SIGN_TYPE signType) {
        this.servicesContainer = servicesContainer;
        this.httpFunctionMap = this.initHttpFunctionMap();
        this.signType = signType;
    }

    private Map<HttpMethod, Function<HttpRequest, HttpResponse>> initHttpFunctionMap() {
        HashMap<HttpMethod, Function<HttpRequest, HttpResponse>> map = new HashMap<HttpMethod, Function<HttpRequest, HttpResponse>>(4);
        map.put(HttpMethod.GET, this.servicesContainer.getHttpClientManager()::get);
        map.put(HttpMethod.POST, this.servicesContainer.getHttpClientManager()::post);
        map.put(HttpMethod.PUT, this.servicesContainer.getHttpClientManager()::put);
        map.put(HttpMethod.DELETE, this.servicesContainer.getHttpClientManager()::delete);
        return map;
    }

    protected ResponseBody execute(BaseRequest domain, Function<HttpRequest, HttpResponse> httpFunction) {
        SignatureBuilder signatureBuilder = this.signatureBuilder(domain);
        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));
        HttpRequestBuilder httpRequestBuilder = this.requestBuilder(domain, signature);
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse httpResponse = httpFunction.apply(httpRequest);
        return this.parseResponseBody(httpResponse);
    }

    protected ResponseBody parseResponseBody(HttpResponse httpResponse) {
        try {
            ResponseBody responseBody = this.servicesContainer.getMessageConverter().getJsonSerializer().parse(httpResponse.getBodyResource().read(), ResponseBody.class);
            httpResponse.setBody(responseBody);
            responseBody.setHeaders(httpResponse.getHeaders());
            httpResponse.getHeaders().get((Object)"Request_Id").stream().findFirst().ifPresent(responseBody::setRequestId);
            httpResponse.getHeaders().get((Object)"X-Ca-Request-Id").stream().findFirst().ifPresent(responseBody::setTraceId);
            return responseBody;
        }
        catch (IOException | RuntimeException e) {
            try {
                String source = httpResponse.getBodyResource().asCharSource(StandardCharsets.UTF_8).read();
                ResponseBodyString responseBody = new ResponseBodyString(source);
                httpResponse.setBody(responseBody);
                StatusCode statusCode = new StatusCode();
                statusCode.setStatusCode(500);
                statusCode.setReasonPhrase(e.getMessage());
                httpResponse.setHttpStatus(statusCode);
                return responseBody;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract SignatureBuilder createSignatureBuilder(BaseRequest var1);

    protected abstract HttpRequestBuilder createRequestBuilder(BaseRequest var1);

    public SignatureBuilder signatureBuilder(BaseRequest domain) {
        SignatureBuilder signatureBuilder = this.createSignatureBuilder(domain);
        signatureBuilder.signature();
        return signatureBuilder;
    }

    public HttpRequestBuilder requestBuilder(BaseRequest domain, String signature) {
        HttpRequestBuilder httpRequestBuilder = this.createRequestBuilder(domain).requestUrl().headers(signature);
        if (HttpMethod.GET.equals((Object)domain.getHttpMethod())) {
            httpRequestBuilder.queryParams();
        } else {
            httpRequestBuilder.body();
        }
        return httpRequestBuilder;
    }

    public Enums.SIGN_TYPE getSignType() {
        return this.signType;
    }
}

