/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.usage;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

public class GetSimUsage
extends BaseRequest {
    private String simId;
    private String category;
    private String periodType;
    private String beginFrom;
    private String endBy;

    public GetSimUsage(int nonce, String simId, String category, String periodType, String beginFrom, String endBy) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.category = category;
        this.periodType = periodType;
        this.beginFrom = beginFrom;
        this.endBy = endBy;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getUsage().getSimUsage(this.simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", this.simId);
        mapToSign.put("category", this.category);
        mapToSign.put("period_type", this.periodType);
        mapToSign.put("begin_from", this.beginFrom);
        mapToSign.put("end_by", this.endBy);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        queryParams.put((Object)"category", (Object)this.category);
        queryParams.put((Object)"period_type", (Object)this.periodType);
        queryParams.put((Object)"begin_from", (Object)this.beginFrom);
        queryParams.put((Object)"end_by", (Object)this.endBy);
    }

    @Override
    public void addBody(Map<String, Object> body) {
    }

    public String getSimId() {
        return this.simId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public String getBeginFrom() {
        return this.beginFrom;
    }

    public String getEndBy() {
        return this.endBy;
    }
}

