/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.sms;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.linksfield.cube.partnersdk.sdk.modules.sms.SendSms;
import net.linksfield.cube.partnersdk.utils.AssertUtils;

public class SendSmsBuilder {
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_BINARY = 2;
    private SendSms sendSms;

    SendSmsBuilder(SendSms sendSms) {
        this.sendSms = sendSms;
    }

    public SendSmsBuilder iccids(Collection<String> iccids) {
        AssertUtils.isTrue(iccids.size() <= 100, "max 100 ICCIDs");
        ArrayList<String> simIds = new ArrayList<String>(iccids);
        this.sendSms.setSimIds(simIds);
        return this;
    }

    public SendSmsBuilder iccids(String ... iccids) {
        AssertUtils.isTrue(iccids != null && iccids.length <= 100, "max 100 ICCIDs");
        ArrayList simIds = Lists.newArrayList((Object[])iccids);
        this.sendSms.setSimIds(simIds);
        return this;
    }

    public SendSmsBuilder messageType(int type) {
        SendSms.Message message = this.makeMessageExist();
        message.setType(type);
        return this;
    }

    public SendSmsBuilder messageContent(String content) {
        AssertUtils.notNull(content, "content must not be null");
        AssertUtils.isTrue(content.length() <= 140, "max 140 characters");
        SendSms.Message message = this.makeMessageExist();
        message.setContent(content);
        return this;
    }

    public SendSms build() {
        AssertUtils.notNull(this.sendSms.getSimIds(), "iccids must not be null");
        AssertUtils.notNull(this.sendSms.getMessage(), "message type or content not be null");
        AssertUtils.isTrue(this.sendSms.getMessage().getType() == 1 || this.sendSms.getMessage().getType() == 2, "message type allow value is [1 , 2]");
        AssertUtils.notNull(this.sendSms.getMessage().getContent(), "message content must not be null");
        return this.sendSms;
    }

    private SendSms.Message makeMessageExist() {
        SendSms.Message message = this.sendSms.getMessage();
        if (message == null) {
            message = new SendSms.Message();
        }
        this.sendSms.setMessage(message);
        return message;
    }
}

