/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.sms;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.sms.SendSmsBuilder;

public class SendSms
extends BaseRequest {
    private List<String> simIds;
    private Message message;

    public SendSms(int nonce, List<String> simIds, Message message) {
        super(HttpMethod.POST, nonce);
        this.simIds = simIds;
        this.message = message;
    }

    private SendSms(int nonce) {
        super(HttpMethod.POST, nonce);
    }

    public static SendSmsBuilder builder(int nonce) {
        SendSms domain = new SendSms(nonce);
        SendSmsBuilder builder = new SendSmsBuilder(domain);
        return builder;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSms().sendSms();
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_ids", this.simIds);
        body.put("message", this.message);
    }

    public List<String> getSimIds() {
        return this.simIds;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setSimIds(List<String> simIds) {
        this.simIds = simIds;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public static class Message {
        private String content;
        private int type;

        public String getContent() {
            return this.content;
        }

        public int getType() {
            return this.type;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "SendSms.Message(content=" + this.getContent() + ", type=" + this.getType() + ")";
        }
    }
}

