/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.sms;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.sms.ListMOBySimIdBuilder;

public class ListMOBySimId
extends BaseRequestV2 {
    private String simId;
    private String status;
    private String beginFrom;
    private String endBy;
    private Integer pageNo;
    private Integer pageSize;

    public ListMOBySimId(int nonce, String simId, String status, String beginFrom, String endBy, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.status = status;
        this.beginFrom = beginFrom;
        this.endBy = endBy;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    private ListMOBySimId(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public static ListMOBySimIdBuilder builder(int nonce, String simId) {
        return new ListMOBySimIdBuilder(new ListMOBySimId(nonce), simId);
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSms().listMOBySimId(this.simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        this.addOptionalQueryParam(queryParams, "status", this.status);
        this.addOptionalQueryParam(queryParams, "begin_from", this.beginFrom);
        this.addOptionalQueryParam(queryParams, "end_by", this.endBy);
        this.addOptionalQueryParam(queryParams, "page_no", this.pageNo);
        this.addOptionalQueryParam(queryParams, "page_size", this.pageSize);
    }

    @Override
    public void addBody(Map<String, Object> body) {
    }

    public String getSimId() {
        return this.simId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBeginFrom() {
        return this.beginFrom;
    }

    public String getEndBy() {
        return this.endBy;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setSimId(String simId) {
        this.simId = simId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setBeginFrom(String beginFrom) {
        this.beginFrom = beginFrom;
    }

    public void setEndBy(String endBy) {
        this.endBy = endBy;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

