/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.sim;

import java.util.Collection;
import net.linksfield.cube.partnersdk.sdk.modules.sim.BatchQuerySim;

public class BatchQuerySimBuilder {
    private BatchQuerySim batchQuerySim;

    BatchQuerySimBuilder(BatchQuerySim batchQuerySim) {
        this.batchQuerySim = batchQuerySim;
    }

    public BatchQuerySimBuilder currentLifecycle(String currentLifecycle) {
        if (currentLifecycle == null || currentLifecycle.trim().length() == 0) {
            return this;
        }
        try {
            int status = Integer.parseInt(currentLifecycle);
            this.batchQuerySim.setStatus(status);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public BatchQuerySimBuilder status(int status) {
        this.batchQuerySim.setStatus(status);
        return this;
    }

    public BatchQuerySimBuilder pageNo(Integer pageNo) {
        this.batchQuerySim.setPageNo(pageNo);
        return this;
    }

    public BatchQuerySimBuilder pageSize(Integer pageSize) {
        this.batchQuerySim.setPageSize(pageSize);
        return this;
    }

    public BatchQuerySimBuilder orderId(String orderId) {
        this.batchQuerySim.setOrderId(orderId);
        return this;
    }

    public BatchQuerySimBuilder simId(String simId) {
        this.batchQuerySim.addSimId(simId);
        return this;
    }

    public BatchQuerySimBuilder simIds(Collection<String> simIds) {
        this.batchQuerySim.makeSimIdsExist();
        this.batchQuerySim.getSimIds().addAll(simIds);
        return this;
    }

    public BatchQuerySimBuilder simIds(String[] simIds) {
        this.batchQuerySim.makeSimIdsExist();
        for (String simId : simIds) {
            this.batchQuerySim.getSimIds().add(simId);
        }
        return this;
    }

    public BatchQuerySim build() {
        return this.batchQuerySim;
    }
}

