/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.sim.BatchQuerySimBuilder;

public class BatchQuerySim
extends BaseRequestV2 {
    private Integer status;
    private int pageNo = 1;
    private int pageSize = 100;
    private String orderId;
    private List<String> simIds;

    public BatchQuerySim(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize, String orderId) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderId = orderId;
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize, String orderId, List<String> simIds) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderId = orderId;
        this.simIds = simIds;
    }

    public static BatchQuerySimBuilder builder(int nonce) {
        return new BatchQuerySimBuilder(new BatchQuerySim(nonce));
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().batchQuerySim();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        this.addOptionalQueryParam(queryParams, "status", this.status);
        this.addOptionalQueryParam(queryParams, "page_no", this.pageNo);
        this.addOptionalQueryParam(queryParams, "page_size", this.pageSize);
        this.addOptionalQueryParam(queryParams, "order_id", this.orderId);
        this.addOptionalQueryParam(queryParams, "sim_ids", this.simIds.stream().collect(Collectors.joining(",")));
    }

    @Override
    public void addBody(Map<String, Object> body) {
    }

    void makeSimIdsExist() {
        if (this.simIds == null) {
            this.simIds = new ArrayList<String>(100);
        }
    }

    void addSimId(String simId) {
        this.makeSimIdsExist();
        this.simIds.add(simId);
    }

    public Integer getStatus() {
        return this.status;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public List<String> getSimIds() {
        return this.simIds;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setSimIds(List<String> simIds) {
        this.simIds = simIds;
    }
}

