/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.Enums;
import net.linksfield.cube.partnersdk.domain.SignatureBuilder;
import net.linksfield.cube.partnersdk.domain.SignatureBuilderV1;
import net.linksfield.cube.partnersdk.domain.SignatureBuilderV2;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.DomainSignatureEvent;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilder;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilderV1;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilderV2;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.ResponseBody;
import net.linksfield.cube.partnersdk.rest.ResponseBodyString;
import net.linksfield.cube.partnersdk.rest.StatusCode;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.proxy.extend.IModuleExecutor;

public class SuspendModuleExecutor
implements IModuleExecutor {
    @Override
    public ResponseBody execute(Enums.SIGN_TYPE signType, BaseRequest domain, ServicesContainer servicesContainer) {
        if (Enums.SIGN_TYPE.V2.equals((Object)signType)) {
            return this.executeV2(domain, servicesContainer);
        }
        return this.executeV1(domain, servicesContainer);
    }

    private ResponseBody executeV2(BaseRequest domain, ServicesContainer servicesContainer) {
        SignatureBuilderV2 signatureBuilder = new SignatureBuilderV2(domain, servicesContainer);
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilderV2(domain, servicesContainer).requestUrl();
        httpRequestBuilder.queryParams().body();
        signatureBuilder.signature(httpRequestBuilder);
        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));
        httpRequestBuilder.headers(signature);
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse httpResponse = servicesContainer.getHttpClientManager().put(httpRequest);
        return this.parseResponseBody(httpResponse, servicesContainer);
    }

    private ResponseBody executeV1(BaseRequest domain, ServicesContainer servicesContainer) {
        SignatureBuilderV1 signatureBuilder = new SignatureBuilderV1(domain, servicesContainer);
        ((SignatureBuilder)signatureBuilder).signature();
        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));
        HttpRequestBuilderV1 httpRequestBuilder = new HttpRequestBuilderV1(domain, servicesContainer);
        httpRequestBuilder.requestUrl().headers(signature);
        httpRequestBuilder.queryParams();
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse httpResponse = servicesContainer.getHttpClientManager().put(httpRequest);
        return this.parseResponseBody(httpResponse, servicesContainer);
    }

    protected ResponseBody parseResponseBody(HttpResponse httpResponse, ServicesContainer servicesContainer) {
        try {
            ResponseBody responseBody = servicesContainer.getMessageConverter().getJsonSerializer().parse(httpResponse.getBodyResource().read(), ResponseBody.class);
            httpResponse.setBody(responseBody);
            return responseBody;
        }
        catch (IOException | RuntimeException e) {
            try {
                String source = httpResponse.getBodyResource().asCharSource(StandardCharsets.UTF_8).read();
                ResponseBodyString responseBody = new ResponseBodyString(source);
                httpResponse.setBody(responseBody);
                StatusCode statusCode = new StatusCode();
                statusCode.setStatusCode(500);
                statusCode.setReasonPhrase(e.getMessage());
                httpResponse.setHttpStatus(statusCode);
                return responseBody;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

