/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.service;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

public class AddBundle
extends BaseRequest {
    private String simId;
    private String bundleId;
    private int bundleType;
    private int cycles;

    public AddBundle(int nonce, String simId, String bundleId, int bundleType, int cycles) {
        super(HttpMethod.POST, nonce);
        this.simId = simId;
        this.bundleId = bundleId;
        this.bundleType = bundleType;
        this.cycles = cycles;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getService().addBundle(this.simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", this.simId);
        mapToSign.put("bundle_id", this.bundleId);
        mapToSign.put("bundle_type", this.bundleType);
        mapToSign.put("cycles", this.cycles);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_id", this.simId);
        body.put("bundle_id", this.bundleId);
        body.put("bundle_type", this.bundleType);
        body.put("cycles", this.cycles);
    }

    public String getSimId() {
        return this.simId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    public int getCycles() {
        return this.cycles;
    }
}

