/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.orders;

import net.linksfield.cube.partnersdk.sdk.modules.orders.PlaceOrder;

public class PlaceOrderBuilder {
    private PlaceOrder placeOrder;

    PlaceOrderBuilder(PlaceOrder placeOrder) {
        this.placeOrder = placeOrder;
    }

    public PlaceOrderBuilder addItem(String id, int quantity, int price) {
        this.placeOrder.skus.add(new PlaceOrder.Sku(id, quantity, price));
        return this;
    }

    public PlaceOrderBuilder accounting(String currency, int payChannel) {
        this.placeOrder.accounting = new PlaceOrder.Accounting(currency, payChannel);
        return this;
    }

    public PlaceOrderBuilder accounting(String currency, int payChannel, String couponId) {
        this.placeOrder.accounting = new PlaceOrder.Accounting(currency, payChannel, couponId);
        return this;
    }

    public PlaceOrderBuilder accounting(String currency, int payChannel, String couponId, Integer discount) {
        this.placeOrder.accounting = new PlaceOrder.Accounting(currency, payChannel, couponId, discount);
        return this;
    }

    public PlaceOrderBuilder extra(String po, String remark) {
        this.placeOrder.extra = new PlaceOrder.Extra(po, remark);
        return this;
    }

    public PlaceOrderBuilder address(String country, String province, String city, String district, String town, String detail, String zip, String specialInstructions) {
        this.placeOrder.address = new PlaceOrder.DeliveryAddress(country, province, city, district, town, detail, zip, specialInstructions);
        return this;
    }

    public PlaceOrderBuilder address(String country, String province, String city, String detail) {
        this.placeOrder.address = new PlaceOrder.DeliveryAddress(country, province, city, detail);
        return this;
    }

    public PlaceOrderBuilder consignee(String name, String mobileNo) {
        this.placeOrder.contact = new PlaceOrder.Contact(name, mobileNo);
        return this;
    }

    public PlaceOrderBuilder consignee(String name, String telArea, String telCode, String mobileNo, String mobileArea, String email) {
        this.placeOrder.contact = new PlaceOrder.Contact(name, telArea, telCode, mobileNo, mobileArea, email);
        return this;
    }

    public PlaceOrder build() {
        return this.placeOrder;
    }
}

