/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.orders.PlaceOrderBuilder;
import net.linksfield.cube.partnersdk.utils.AssertUtils;
import net.linksfield.cube.partnersdk.utils.ReflectUtils;

public class PlaceOrder
extends BaseRequestV2 {
    List<Sku> skus = new ArrayList<Sku>();
    Accounting accounting;
    Extra extra;
    DeliveryAddress address;
    Contact contact;

    private PlaceOrder(int nonce) {
        super(HttpMethod.POST, nonce);
    }

    public static PlaceOrderBuilder builder(int nonce) {
        PlaceOrder domain = new PlaceOrder(nonce);
        PlaceOrderBuilder builder = new PlaceOrderBuilder(domain);
        return builder;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().order();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
    }

    public static PlaceOrder customization(int nonce, final Map<String, Object> customBody) {
        return new PlaceOrder(nonce){

            @Override
            public void addBody(Map<String, Object> body) {
                body.putAll(customBody);
            }
        };
    }

    @Override
    public void addBody(Map<String, Object> body) {
        AssertUtils.isTrue(this.skus.size() > 0, "The product list is a required");
        AssertUtils.notNull(this.address, "The shipping address information is required");
        AssertUtils.notNull(this.contact, "The consignee information is required");
        body.put("items", ReflectUtils.objectToMap(this.skus));
        Optional.ofNullable(this.extra).ifPresent(ex -> body.put("extra", ReflectUtils.objectToMap(ex)));
        Optional.ofNullable(this.accounting).ifPresent(ex -> body.put("accounting", ReflectUtils.objectToMap(ex)));
        body.put("delivery_address", ReflectUtils.objectToMap(this.address));
        body.put("contact", ReflectUtils.objectToMap(this.contact));
    }

    public static class DeliveryAddress {
        private String country;
        private String province;
        private String city;
        private String district;
        private String town;
        private String detail;
        private String zip;
        private String special_instructions;

        public DeliveryAddress(String country, String province, String city, String detail) {
            this.country = country;
            this.province = province;
            this.city = city;
            this.detail = detail;
        }

        public String getCountry() {
            return this.country;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public String getDistrict() {
            return this.district;
        }

        public String getTown() {
            return this.town;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getZip() {
            return this.zip;
        }

        public String getSpecial_instructions() {
            return this.special_instructions;
        }

        public DeliveryAddress(String country, String province, String city, String district, String town, String detail, String zip, String special_instructions) {
            this.country = country;
            this.province = province;
            this.city = city;
            this.district = district;
            this.town = town;
            this.detail = detail;
            this.zip = zip;
            this.special_instructions = special_instructions;
        }
    }

    public static class Contact {
        private String name;
        private String tel_area;
        private String tel_code;
        private String mobile_no;
        private String mobile_area;
        private String email;

        public Contact(String name, String mobile_no) {
            this.name = name;
            this.mobile_no = mobile_no;
            this.mobile_area = "86";
        }

        public String getName() {
            return this.name;
        }

        public String getTel_area() {
            return this.tel_area;
        }

        public String getTel_code() {
            return this.tel_code;
        }

        public String getMobile_no() {
            return this.mobile_no;
        }

        public String getMobile_area() {
            return this.mobile_area;
        }

        public String getEmail() {
            return this.email;
        }

        public Contact(String name, String tel_area, String tel_code, String mobile_no, String mobile_area, String email) {
            this.name = name;
            this.tel_area = tel_area;
            this.tel_code = tel_code;
            this.mobile_no = mobile_no;
            this.mobile_area = mobile_area;
            this.email = email;
        }
    }

    public static class Extra {
        private String po;
        private String remarks;

        public String getPo() {
            return this.po;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public Extra(String po, String remarks) {
            this.po = po;
            this.remarks = remarks;
        }
    }

    public static class Accounting {
        private String currency;
        private int pay_channel;
        private String coupon_id;
        private Integer discount;

        public Accounting(String currency, int pay_channel) {
            this.currency = currency;
            this.pay_channel = pay_channel;
        }

        public Accounting(String currency, int pay_channel, String coupon_id) {
            this.currency = currency;
            this.pay_channel = pay_channel;
            this.coupon_id = coupon_id;
        }

        public Accounting(String currency, int pay_channel, String coupon_id, Integer discount) {
            this.currency = currency;
            this.pay_channel = pay_channel;
            this.coupon_id = coupon_id;
            this.discount = discount;
        }

        public Accounting() {
            this.currency = "CNY";
            this.pay_channel = 1;
        }

        public String getCurrency() {
            return this.currency;
        }

        public int getPay_channel() {
            return this.pay_channel;
        }

        public String getCoupon_id() {
            return this.coupon_id;
        }

        public Integer getDiscount() {
            return this.discount;
        }
    }

    public static class Sku {
        private int price;
        private int quantity;
        private String id;

        public Sku(String id, int quantity, int price) {
            this.id = id;
            this.quantity = quantity;
            this.price = price;
        }

        public int getPrice() {
            return this.price;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public String getId() {
            return this.id;
        }
    }
}

