/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.orders.ListSkusBuilder;

public class ListSkus
extends BaseRequestV2 {
    private Integer category;
    private Integer status;
    private Integer pageNo;
    private Integer pageSize;

    public ListSkus(int nonce, Integer category, Integer status, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.category = category;
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public ListSkus(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public static ListSkusBuilder builder(int nonce) {
        return new ListSkusBuilder(new ListSkus(nonce));
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().list();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        this.addOptionalQueryParam(queryParams, "category", this.category);
        this.addOptionalQueryParam(queryParams, "status", this.status);
        this.addOptionalQueryParam(queryParams, "page_no", this.pageNo);
        this.addOptionalQueryParam(queryParams, "page_size", this.pageSize);
    }

    @Override
    public void addBody(Map<String, Object> body) {
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

