/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk.modules.cdr;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.sdk.modules.cdr.SimCdrBuilder;

public class SimCdr
extends BaseRequest {
    private String simId;
    private String receivedStartTime;
    private String receivedEndBy;
    private Integer pageNo;
    private Integer pageSize;

    public SimCdr(int nonce, String simId, String receivedStartTime, String receivedEndBy, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.receivedStartTime = receivedStartTime;
        this.receivedEndBy = receivedEndBy;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    SimCdr(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public static SimCdrBuilder builder(int nonce, String simId) {
        return new SimCdrBuilder(new SimCdr(nonce), simId);
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getCdr().getBySimId(this.simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", this.simId);
        if (this.receivedStartTime != null) {
            mapToSign.put("received_start_time", this.receivedStartTime);
        }
        if (this.receivedEndBy != null) {
            mapToSign.put("received_end_by", this.receivedEndBy);
        }
        if (this.pageNo != null) {
            mapToSign.put("page_no", this.pageNo);
        }
        if (this.pageSize != null) {
            mapToSign.put("page_size", this.pageSize);
        }
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        if (this.receivedStartTime != null) {
            queryParams.put((Object)"received_start_time", (Object)this.receivedStartTime);
        }
        if (this.receivedEndBy != null) {
            queryParams.put((Object)"received_end_by", (Object)this.receivedEndBy);
        }
        if (this.pageNo != null) {
            queryParams.put((Object)"page_no", (Object)this.pageNo.toString());
        }
        if (this.pageSize != null) {
            queryParams.put((Object)"page_size", (Object)this.pageSize.toString());
        }
    }

    @Override
    public void addBody(Map<String, Object> body) {
    }

    public String getSimId() {
        return this.simId;
    }

    public String getReceivedStartTime() {
        return this.receivedStartTime;
    }

    public String getReceivedEndBy() {
        return this.receivedEndBy;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setSimId(String simId) {
        this.simId = simId;
    }

    public void setReceivedStartTime(String receivedStartTime) {
        this.receivedStartTime = receivedStartTime;
    }

    public void setReceivedEndBy(String receivedEndBy) {
        this.receivedEndBy = receivedEndBy;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

