/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.sdk;

import java.io.Closeable;
import java.io.IOException;
import net.linksfield.cube.partnersdk.domain.CommonVariables;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.SdkInitEvent;
import net.linksfield.cube.partnersdk.sdk.SdkV1;
import net.linksfield.cube.partnersdk.sdk.SdkV2;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.proxy.ProxyHelper;

public final class PartnerClient
implements Closeable {
    private CommonVariables commonVariables;
    private ServicesContainer servicesContainer;
    private SdkV1 sdkV1;
    private SdkV2 sdkV2;

    public PartnerClient(String accessKey, String privateKey) {
        this.commonVariables = new CommonVariables(accessKey, privateKey);
        this.init(this.commonVariables);
    }

    public PartnerClient(String accessKey, String privateKey, String acceptLanguage) {
        this.commonVariables = new CommonVariables(accessKey, privateKey);
        this.commonVariables.setAcceptLanguage(acceptLanguage);
        this.init(this.commonVariables);
    }

    private void init(CommonVariables commonVariables) {
        ServicesContainer servicesContainer;
        this.commonVariables = commonVariables;
        this.servicesContainer = servicesContainer = new ServicesContainer(this.commonVariables);
        this.initSdk(servicesContainer);
        Events.dispatch(new SdkInitEvent(this.commonVariables.getAccessKey(), this.commonVariables.getPrivateKey()));
    }

    public SdkV1 v1() {
        return this.sdkV1;
    }

    public SdkV2 v2() {
        return this.sdkV2;
    }

    private void initSdk(ServicesContainer servicesContainer) {
        this.sdkV1 = ProxyHelper.createSdkV1Proxy(servicesContainer);
        this.sdkV2 = ProxyHelper.createSdkV2Proxy(servicesContainer);
    }

    @Override
    public void close() throws IOException {
        this.servicesContainer.getHttpClientManager().close();
        Events.stop();
    }
}

